---
title: Python Sequence Types
---
These represent finite ordered sets indexed by non-negative numbers. The built-in function `len()` returns the number of items of a sequence. When the length of a sequence is `n`, the index set contains the numbers `0, 1, ..., n-1`. Item `i` of sequence a is selected by `a<a href='https://docs.python.org/3/reference/datamodel.html#the-standard-type-hierarchy' target='_blank' rel='nofollow'>i]`.

[Python Docs - Standard Type Hierarchy</a>

## More

*   Built-in sequence types are:
    *   `list`

    *   `tuple`
    *   `range`
*   Built-in sequence types are iterable types (implement required `__iter__()` method).

*   Operations:

    *   <a href='https://docs.python.org/3/library/stdtypes.html#common-sequence-operations' target='_blank' rel='nofollow'>Common Sequence Operations</a>

    *   <a href='https://docs.python.org/3/library/stdtypes.html#mutable-sequence-types' target='_blank' rel='nofollow'>Mutable Sequence Types</a>
    *   <a href='https://docs.python.org/3/library/stdtypes.html#immutable-sequence-types' target='_blank' rel='nofollow'>Immutable Sequence Types</a>