---
title: R
---

## What is R?
R is an open source programming language and software environment for statistical computing and graphics. It is one of the primary languages used by data scientists and statisticians. It is supported by the R Foundation for Statistical Computing and a large community of open source developers. Since R utilizes a command line interface, there can be a steep learning curve for some individuals who are used to using GUI focused programs such as SPSS and SAS so extensions to R such as RStudio can be helpful. Since R is an open source program and available for free, there can a large attraction for academics whose access to statistical programs are regulated through their association to various colleges or universities.

R has multiple packages (which are similar to libraries used in languages like python) on repositories like CRAN and bioconductor, which can be utilized for various purposes.


## Installation
First, download R from its <a href='https://www.r-project.org/' target='_blank' rel='nofollow'>Official Site</a> according to your operating system.
Then install it on your computer. For help in installation refer to the [reference](#reference) section below.

## Popular R Tools & Packages
* [RStudio](https://www.rstudio.com/products/rstudio/) is an integrated development environment (IDE) for R. It includes a console, syntax-highlighting editor that supports direct code execution, as well as tools for plotting, history, debugging and workspace management.
* [The Comprehensive R Archive Network (CRAN)](https://cran.r-project.org/) is a leading source for R tools and resources. 
* [Tidyverse](https://www.tidyverse.org/) is an opinionated collection of R packages designed for data science like ggplot2, dplyr, readr, tidyr, purr, tibble.
* [data.table](https://github.com/Rdatatable/data.table/wiki) is an implementation of base `data.frame` focused on improved performance and terse, flexible syntax.
* [Shiny](https://shiny.rstudio.com/) framework for building dashboard style web apps in R.

## Where to learn R for free

* [R Studio](https://www.rstudio.com/online-learning/)
* [Code school](http://tryr.codeschool.com/)
* [Coursera -allows to audit course for free but certification is paid.](https://www.coursera.org/learn/r-programming)
* [DataCamp -allows to complete the introductory part for free.](https://www.datacamp.com)
* [R for Data Science -is a book which is available free to read online.](http://r4ds.had.co.nz/)
* [Mastering Software Development in R -is a free e-book addressing the Tidyverse among other topics](https://bookdown.org/rdpeng/RProgDA/)
* [edX -allows to audit course for free but certification is paid.](https://www.edx.org/learn/r-programming)
* [Advanced R](https://adv-r.hadley.nz/)
* [RSeek](http://rseek.org/)
* [Udemy](https://www.udemy.com/r-basics/)
* [Quick R](https://www.statmethods.net)
* [Swirl Courses](https://swirlstats.com)
 
 ## Reference
 * [Installing R on Windows](http://youtu.be/Ohnk9hcxf9M)
 * [Installing R on Mac](https://youtu.be/uxuuWXU-7UQ)
 * [Installing R on Unix-alikes](https://cran.r-project.org/doc/manuals/r-release/R-admin.html#Installing-R-under-Unix_002dalikes)
  * [Installing R on Ubuntu](https://cran.r-project.org/bin/linux/ubuntu/)
