---
title: React Native
---

## React Native

React Native is a cross-platform framework for building mobile applications that can run outside of the browser  —  most commonly iOS and Android applications.

It can be used to build applications on Windows devices, desktop OS’s, and Apple TVs additionally, but this guide will only be covering its most common purpose  —  Android and iOS applications.

**Table of Contents**

- [What is React Native?](#what-is-react-native)
- [Reasons to choose React Native](#reasons-to-choose-react-native)
- [How to Get Started with React Native](#how-to-get-started-with-react-native)

### What is React Native?

React Native falls in-between native and hybrid applications on the mobile app spectrum. The user interface you create is entirely native and the overall performance of the application is nearly as good as writing a native app using languages such as Swift or Java. It also gives you the flexibility to embed web views (webpages) or native code (Java/Kotlin for Android, Objective C/Swift for iOS) inside your applications wherever you want.

It follows the same pattern as React, where the views (what you see on the screen) are rendered from JavaScript files. The difference is that React Native supplies its own API for handling native mobile views vs the DOM on the web. <!-- If you are confused about how this works, follow this guide on freeCodeCamp and it will take you step by step through these concepts. -->

### Reasons to choose React Native

1. **Code reusability**  —  It uses one codebase that is shared between both platforms.
1. **Reuse web tools and skills**  —  Reuses JavaScript knowledge, tools and utilities like `axios`, Redux, and other libraries that don’t require the DOM from the web.
1. **Optimized for developer productivity**  —  Comes with features like hot/live module reloading and chrome developer tools for debugging out of the box!
1. **Performance**  —  Performs better than hybrid application frameworks like Ionic and Cordova since it's not using web views.
1. **Corporate backing**  —  Lots of companies support and contribute to React Native including Walmart, Airbnb, Wix, and, of course, Facebook.
1. **Community**  —  React Native has a large (and growing) community with over 1500 contributors to the core project and thousands more who contribute to various libraries.
1. **Better user experience**  —  React Native uses JavaScript to render native components from your phone's OS. In other words, the application's user interface (UI) is entirely native!
1. **Cross-Platform** - Great way to prototype and save time while building either a universal user interface or platform specific mobile application that can run on both iOS and Android devices.

### How to Get Started with React Native

There are three quick easy ways to get started with React Native. Depending on your situation, one can be a better option for you.

1. [Create React Native App](https://www.npmjs.com/package/create-react-native-app)- Similar to Create React App it get up in running using the terminal.
1. [Expo](https://expo.io) - Best for prototyping apps or useful if an app is in an earlier stage. Using Expo you can even create an quick app using drag and drop features from snack.expo.io in the browser.
1. [Ignite CLI](https://github.com/infinitered/ignite) - Empowers developers to easily create a new React Native app with plug ins. Ignite CLI also enables developers to easily setup best practices. 
