---
title: Why React
---

# Why React.js?

## Simplicity
React.js is not a full fledged JavaScript framework like Angular.js or other popular frontend frameworks. Instead, React.js is a JavaScript library that acts as the 'V' in MVC (Model View Controller). It is simply a view engine that can be dropped in and used with a plethora of other tools for the data and model part of MVC (most popularly Redux and Node.js).

## Reusability
React allows you to create reusable components that you can modify with props. This gives a lot of flexibility in development and speeds it up by huge margins. 

## Readability
React is a component-driven library.  All this means is that you can create snippets of code with built in functionality (and even styling!) that can be used again and again.  It is a very intuitive way of coding, and not only that, it makes all of your code look so much more readable.  Seeing <SearchBar /> in the code is obviously a lot easier to understand than a huge blob of HTML.

## Performance
Since React makes use of a _Virtual DOM_, it can selectively update portions of the page as needed rather than always having to complete an entire page reload. In many cases, not updating the entire DOM will save considerably on performance. Moreover, many of the built-in functions (such as Lifecycle functions) also have performance benefits as they often help to check if a re-render is even needed to begin with.

## Low learning curve
Of the major frontend "frameworks" available, React has a relatively low barrier to entry and has a quick ramp up time. In addition, React's official documentation is extremely clear and provide many examples for most of the common use cases.  Unlike Angular, it is easy to get started with little to no knowledge of React itself and learn the more complicated features as you go!

## Tooling
The tools and software commonly utilized with React are incredibly well maintained and supported and provide several different avenues of best practices to follow when developing web applications. Some of these tools include Redux, React-router, Thunk, and many others. There are also a number of development tools, such as a React and Redux Chrome extension, which helps with debugging your React applications.

## Support
React is created and maintained by the folks at Facebook and is used by individuals and companies all over the world in large volume. This means React is constantly improving and any problems you may experience are probably already solved on Stack Overflow.

Other than the above, we can take our React knowledge to develop mobile native applications using react-native and also take our knowledge and expand it to VR using react-vr. Basically learning React opens us up to various other oppurtunities like using it for  Web, VR, PWA(Progressive Web App) and many others

## Additional Resources
- To learn more about why React is so great check out the [official website](https://reactjs.org/)
- [React crash course on YouTube](https://www.youtube.com/watch?v=A71aqufiNtQ)
