---
title: Robotics
---
## Robotics

Robotics is about the systems that make up robots. There is no universally applicable definition of a robot. One generally accepted definition is: _A robot is a programmable physical machine that follows the sense, think, act paradigm_. More specifically, a robot needs to sense its environment, use that information as an input to make decisions, and then act accordingly; each system in this paradigm is often a study in itself. There are a multitude of varieties of robot types and component systems. Each robot usually is dedicated to a set of processes with clear objectives.

### Sense

A robot has to sense its environment. For this, it uses different types of sensors. A _sensor_ can be defined as an input device which converts physical parameters into (usually) electrical signals. Cameras in your smartphone are a type of sensors, they convert light into electrical bits of information. A digital thermometer is a sensor that converts heat (temperature) into a electrical signal that can be displayed as a celsius value on its screen. There are always limitations to the accuracy of the output of a sensor, so the output from the sensor is usually further processed to compensate for the errors.

### Think

A robot has to make decisions based on the input it receives from the environment and the way it is programmed. Autonomous functions are those which can be performed by a robot without any human input. Robots usually have a mixture of autonomous and controlled functions (fully autonomous robots are getting common these days). They have an onboard computer that facilitates the computation needed for the decision making process of a robot. For example, commercial consumer [quadcopters](https://en.wikipedia.org/wiki/Quadcopter) are offering a feature where the copter can be asked to follow a moving object. It uses the input from the camera, performs [image processing](https://en.wikipedia.org/wiki/Digital_image_processing) to distinguish the object from the environment and uses [controlled systems](https://en.wikipedia.org/wiki/Control_system) to follow the object. And all of this is done without any human input (ie after the copter is programmed).

### Act

Once the robot makes its decision, it needs to act accordingly. For this purpose, it uses actuators. An _actuator_ is a device that converts energy into motion. Actuators can be classified according to the type of input energy they require. The two most commmon types of actuators are electrical (which use electrical energy to generate motion) and pneumatic (which use air pressure to generate motion). For example, a motor is an actuator that converts electrical energy into rotatory motion. There are always limitations to the accuracy and degree of control of an actuator, hence [control systems](https://en.wikipedia.org/wiki/Control_system) are used in order to compensate those limitations.

### The Three Laws of Robotics
##### *-- Handbook of Robotics, 56th Edition, 2058 A.D.*

1. A robot may not injure a human being or, through inaction, allow a human being to come to harm.
2. A robot must obey the orders given it by human beings except where such orders would conflict with the First Law.
3. A robot must protect its own existence as long as such protection does not conflict with the First or Second Laws.
## Essential things for Robotics.

First, you need to have good amount of patience to ace in Robotics.

1) Start by using an easy programming language that can help you understand how robots work. A good place to start is [Lego Mindstorms](https://www.lego.com/en-us/mindstorms) where you can use a basic representation of programming to make your robot do things. If you don't want to buy [Lego Mindstorms](https://www.lego.com/en-us/mindstorms), that's okay! However, it does help understand the basics of robotics, which will help you better understand the advanced machines you'll work with in the future.
2) Be good at any one programming language to have a good grip over code.
3) Learn Raspberry Pi or Arduino for the proper understanding of electronics and logic.
  Now the difference between Raspberry Pi and Arduino is:
  Raspberry Pi is a SBC(Single-Board-Computer) whereas  Arduino is only a Microcontroller.
  So the difference between the above stuff is quite important.
4) Inverse Kinematics is very important for the designing part. 
  Here is a good resource to learn [Inverse kinematics](https://www.intechopen.com/books/industrial_robotics_theory_modelling_and_control/robot_kinematics__forward_and_inverse_kinematics).
  
  
Putting together, these resources are good enough to kick start your journey with Robotics!

#### More Information

- [Robots (Wikipedia.org)](https://en.wikipedia.org/wiki/Robot)
- [Robotics (Wikipedia.org)](https://en.wikipedia.org/wiki/Robotics)
- [Sensors (electronicshub.org)](https://www.electronicshub.org/different-types-sensors/)
- [Actuator (Wikipedia.org)](https://en.wikipedia.org/wiki/Actuator)
- [Lego Mindstorms (lego.com/en-us/mindstorms)](https://www.lego.com/en-us/mindstorms)

