---
title: Robot Operating System (ROS)
---
## Robot Operating System (ROS)
As opposed to its name, ROS is actually not an Operating System (OS). ROS is an open source collection of software packages and libraries useful in robotic software development and plays the role of middleware. It also includes tools (for visualization, simulation, etc.) and commonly used algorithms for essential functionalities like navigation and planning.

![ROS components](http://www.ros.org/wp-content/uploads/2013/12/ros_equation.png)

Source: http://www.ros.org/

The core idea behind ROS is collaboration in the Robotics community. It eliminates the need for every developer to code for common functionalities and behaviours from scratch.

### Platforms and Programming Languages
Several state-of-the-art and well-known robots use ROS for e.g. the Turtlebots, Aldebaran Robotics' Nao and even iRobot's autonomous vacuum cleaner Roomba. Since Linux is the Operating System of choice in most robots; ROS obviously supports it among some other experimental platforms. At ROSCon 2018, there has also been an experimental release of [ROS for the Windows platform](https://blogs.windows.com/windowsexperience/2018/09/28/bringing-the-power-of-windows-10-to-the-robot-operating-system/).

As of now, ROS libraries are available in C++, Python and Lisp but the concept of ROS itself is language-independent. It can be implemented in other programming languages and there are already libraries available in Java ([Rosjava](http://code.google.com/p/rosjava/)) or Lua. ROSJava is being maintained by Google with the primary aim of compatibility with the Android OS which runs on a large percentage of mobile devices.


### More Information
[ROS (Official website)](http://www.ros.org/)

[Robot Operating System (Wikipedia.org)](https://en.wikipedia.org/wiki/Robot_Operating_System)

[ROS – Robot Operating System (www.generationrobots.com)](https://www.generationrobots.com/blog/en/ros-robot-operating-system-2/)

[Documentation](http://wiki.ros.org/)

[Installation](http://wiki.ros.org/ROS/Installation)

[Tutorials](http://wiki.ros.org/ROS/Tutorials)

