---
title: Ruby Numbers Operations
---
In Ruby you can perform all standard math operations on numbers, including: addition `+`, subtraction `-`, multiplication `*`, division `/`, find remainders `%`, and work with exponents `**`.

## Addition:

*   Numbers can be added together using the `+` operator.
    ```ruby
    15 + 25 #=> 40
    ```

## Subtraction:

*   Numbers can be subtracted from one another using the `-` operator.
    ```ruby
    25 - 15 #=> 10
    ```

## Multiplication:

*   Numbers can be multiplied together using the `*` operator.
    ```ruby
    10 * 5 #=> 50
    ```

## Division:

*   Numbers can be divided by one another using the `/` operator.
    ```ruby
    10 / 5 #=> 2
    ```

## Remainders:

*   Remainders can be found using the modulus `%` operator.
    ```ruby
    10 % 3 #=> 1 # because the remainder of 10/3 is 1
    ```

## Exponents:

*   Exponents can be calculated using the `**` operator.
    ```ruby
    2 ** 3 #=> 8 # because 2 to the third power, or 2 * 2 * 2 = 8
    ```
