---
title: Phishing
---
## Phishing
Phishing is a form of cyberattacks using social engineering, which tricks the user into providing the attacker personal details, such as username, passwords, and credit card numbers, often by pretending to be a trusted organization. 

Cybercriminals often send phishing emails to random email addresses, so anyone can become a victim of phishing. However, hackers may choose to launch a phishing attack at specific organization or individual in a "spear phishing" attack. 

A phishing attack can be from any channel of communication, from email to phone calls. You may, for example, receive an email asking you to change your password because of a security breach. To build a sense of trust, cybercriminals will use the same logo and design of email as those of the organization they are pretending to be. This is why phishing emails can be hard to detect.

To protect yourself from phishing emails, you should look out for signs like these:
- The email does not address you by your name. As mentioned, hackers send phishing emails in random and probably would not know your real name.
- The email has grammatical or spelling mistakes
- The email contains links that would lead to destination different from the text. You can check the destination of a link without clicking it by mousing over the link
- The sender's email address looks like from a trusted organization but might be slightly different. For example, you may receive an email from `hello@goog1e.com` instead of `hello@google.com`, where the former uses the number `1` to replace the character `l`.

While phishing phone calls are less common, you should always be on the look out for them. Most big companies will not make unsolicited phone calls to their customers, so you should apply skepticism to any cold calls you receive.


## More Information:

* [SonicWall - Test your Phishing IQ](https://www.sonicwall.com/en-us/phishing-iq-test)
* [Phishing.Org - Common Phishing Techniques](http://www.phishing.org/phishing-techniques)
