---
title: Security
---
## Security

Information Security (also called "infosec" or just "security") deals with guarding and breaking into systems.

This is a particularly important space right now, following major breaches such as the <a href='https://medium.freecodecamp.org/the-equifax-hack-and-how-to-protect-your-family-all-explained-in-5-minutes-a2b5187cb6c0' target='_blank' rel='nofollow'>2017 Equifax breach</a>.

Information security practitioners are often called "security researchers" or penetration testers "pentesters", though they are also often referred to as "hackers" for hacking into systems.

There are "white hat hackers" (ethical hackers) who try to discover new vulnerabilities and bring them to the attention of the people maintaining those systems, which is called "ethical disclosure". They often do this for prestige in the field, or for "bug bounties" that companies have set aside to compensate people for helping them discover vulnerabilities. 

In an interesting hack on Parity (on the Ethereum blockchain), "white hat hackers" exploited a vulnerability and drained all the wallets of money before a real hacker could exploit the same vulnerability (without returning funds though): https://medium.freecodecamp.org/a-hacker-stole-31m-of-ether-how-it-happened-and-what-it-means-for-ethereum-9e5dc29e33ce. This led to a loss of $31 million, instead of a loss of over $180 million. 

There are also "black hat hackers" who do not disclose the vulnerabilities they discover, and instead use them to create exploits to attack people's systems, or sell the exploits to the highest bidder. They often do this to steal data that they can ransom off, or just release into the open to cause chaos.

The CIA triad is a model used in Information Security to build sound policy. The acronym "CIA" stands for Confidentiality, Integrity, and Availability. These three items are the most important components of security.

Security researchers use a wide variety of methods and tools, which are discussed in this section.

Although hacking is a key threat to secure applications, it is not the only one.  Application developers need to balance user experience with security features.  Some cyber breaches are self-inflicted due to complex or hard to understand security configurations.  What security features should be set by default?  What features should be seemless and which should require explict user consent? 

### Website Security Scanners

#### Qualys Website Scanner
It checks your website for server & application vulnerabilities, hidden malware, and SSL security configuration errors.
1. Scan web servers & apps on the Internet or in your network.
2. Detect vulnerabilities and review ways to fix them.
3. Find malware uploaded by malicious users.
4. Verify that SSL is properly configured and working.

Link: https://www.qualys.com/forms/freescan/website-scan/

#### Pentest-Tools 
It is a security company built by people with passion for cyber security. It is very effective in detecting Cross-Site Scripting (XSS) which is one of the most well known web application vulnerabilities. 

Link: https://pentest-tools.com/website-vulnerability-scanning/xss-scanner-online
