---
title: Social Engineering
---
## Social Engineering

Social Engineering is the art of gaining access to a secured system or resource by exploiting human behavior. It involves tricking people into breaking normal security procedures. Most attack vectors rely heavily on leveraging technical skills to find gaps in the security system. Social Engineering relies heavily on having a good understanding of human psychology. Thoroughly researching the target before an attack makes social engineering a powerful tool in the hands of the attacker. 

#### Traits of a good Social Engineering Hacker

* Demonstrates high emotional intelligence
* Intuitive understanding of human psychology
* Charming and persuasive
* Patient and observant
* Adept at predicting human behavior based on exploiting the human need to be helpful, curious, greedy and vain

#### Some examples of Social Engineering hacks

* Baiting: Leaving a malware infected USB at a coffee shop in the hope that someone is curious enough to plug it in and check it out. Once the person plugs the USB in, malware is installed on their computer. See "More Information" for a Black Hat talk about leaving infected USB drives behind for potential targets and the results of such attacks.

* Pretexting: Telling lies to gain access to private information. An example would be impersonating a bank officer and asking people for personal information to 'confirm their account'. See "More Inforamtion" for a Pre-texting example where a social engineer makes changes to a target's cell phone account with very little known information. 

* Phishing: Sending an email which looks like it is from a trusted source to bait the user into clicking a link (to install malware) or replying with private information. 
See "More Information" for a link to test your phishing knowledge and see if you can tell the differece between a real e-mail and a phishing e-mail.

* Lastly, the 419 scam, also known as Advanced-Fee Scam, is a real life example of social engineering. In Nigeria and other third world countries, people would manipulate people by connecting with people using emotional connections in order to scam money. Usually strategies would include: third world poor country status in need of donations or informing people they won scam money and asking for account numbers. These emails would be very convincing and many have fallen victims to these scams. 

* Infiltrating: impersonating someone legitimate in order to gain physical access to a building/office etc., e.g. the coffee machine repair person


#### Prevention and Security

Because Social Engineering requires little computer experience, it is a readily-available tool for individuals who wish to access sensitive data.

The steps that an idividual can take to protect themselves from these attacks include:
* Avoid sharing sensitive data at all, if possible.
* If you must share, verify the source before giving them sensitive data.
* Be aware of random emails or phone numbers claiming to be friends, family, coworkers, institutuions, etc.
* Be aware of people in real life asking for information they shouldn't necessarily reqire.
* Destroy important documents before throwing them away.

In general, the more you know about these attacks, the better prepared you are. Be concsious of who you share information with and why. 

#### More Information:
* [What is Social Engineering?](https://www.webroot.com/us/en/home/resources/tips/online-shopping-banking/secure-what-is-social-engineering)
* [Protect Yourself from Social Engineering Attacks](http://www.makeuseof.com/tag/protect-8-social-engineering-attacks/)
* [7 Best Social Engineering Hacks Ever](https://www.darkreading.com/the-7-best-social-engineering-attacks-ever/d/d-id/1319411?)
* [Hacking Humans : Social Engineering Techniques and How to Protect Against Them](https://www.youtube.com/watch?v=YVqurfWzB-Q)
* [Does Dropping USB Drives in Parking Lots and Other Places Really Work?](https://www.youtube.com/watch?v=XJCQBqTmGUU)
* [Example of Pretexting](https://www.youtube.com/watch?v=lc7scxvKQOo)
* [Test your Phishing IQ](https://www.sonicwall.com/en-us/phishing-iq-test)
