---
title: Tor (The Onion Router)
---

<p align="center">
  <img alt="Tor Logo" src="https://upload.wikimedia.org/wikipedia/commons/thumb/1/15/Tor-logo-2011-flat.svg/2000px-Tor-logo-2011-flat.svg.png" width="300">
</p>

## Tor

Tor stands for "The Onion Router", which is a free software that helps anonymize its users Internet usage, maintained by the Tor Project.

In addition to the Onion Router, the Tor Project maintains a bundle of software, most notably a web browser, which is often also
called Tor.

The Onion Network works by bouncing a user's requests through a large worldwide, volunteer network of computers. It sends the requests through the system encrypted, only decrypting them when they get to the 'exit node', the last computer in the network for any given request before the request is sent to its destination. This makes the message look like its coming from somewhere other than where it actually originated.

Tor has many use cases. Journalists reporting from areas where their lives may be endangered by the nature of the stories they are breaking, whistleblowers, and people living in oppressive regimes all fit into Tor's more benign use cases, along with anyone more interested in online anonymity.


Tor has gotten a lot of negative attention because of its criminal use case. Criminals, such as drug dealers, can and often do use Tor to cover their tracks, and to set up 'dark markets' to sell their wares without compromising themselves. The 2017 shutdowns of AlphaBay and Hansa certainly prove that this is hardly foolproof.

Edward Snowden, the NSA whistleblower, has mentioned Tor favorably as a very well put-together program. Famously, an internal NSA memo that was leaked referred to it as "the king of high-secure, low-latency internet anonymity There are no contenders to the throne in waiting".

Tor has many other use cases. Journalists reporting from areas where their lives may be endangered by the nature of the stories they are breaking, whistleblowers, and people living in oppressive regimes all fit into Tor's more benign use cases, along with anyone more interested in online anonymity. This is important because everyday things cause us to lose more and more of what little privacy we have left, things like TOR ensure a brighter future.


<p align="center">
  <img alt="OONI Logo" src="https://ooni.torproject.org/images/ooni-header-mascot.png" width="300">
</p>

## OONI 

The Tor Project is dedicated to helping people who are unable to connect to the free and open internet.  The Open Observatory of Network Interference is a free and open source project that can be used to detect instances of censorship.  

The OONI probe application can be ran on a repressive network to determine the extent of the censorship.  For example, some OONI tests send data over an unencrypted channel and compare the data to see if it has been tampered with.  Other tests check for DNS spoofing and transparent proxy servers.  This data is combined from sources around the world to gain a greater understanding of current censorship events.  


#### More Information:

<a href='https://www.torproject.org' target='_blank' rel='nofollow'>The Tor Project</a><br />
<a href='https://www.theguardian.com/world/2013/oct/04/nsa-gchq-attack-tor-network-encryption' target='_blank' rel='nofollow'>NSA and GCHQ try to crack Tor</a></br>
<a href='https://ooni.torproject.org/' target='_blank' rel='nofollow'> OONI -Open Observatory of Network Interference </a>
