---
title: Code Coverage
---

## Code Coverage

When you run automated tests on software to find bugs, **code coverage** is a measurement of how much of the code you are testing is actually executed during the tests.

Code that has not been executed during testing has, by definition, not been tested, and so may contain bugs. So generally speaking, the higher code coverage reported by the test suite, the less chance there is of bugs going unnoticed.

This is not to say that 100% code coverage means 0% chance of bugs, however! It's easy to imagine a situation in which all the available functions in a piece of code are called, but not not necessarily with inputs representing all the kinds of scenarios you might expect from real users. 

The ins and outs of how code coverage will not be of much interest until you are actually using automated testing and trying to ensure you are doing it effectively.

#### More information
[Wikipedia - code coverage](https://en.wikipedia.org/wiki/Code_coverage)

[freeCodeCamp Guide - Test Driven Development](https://guide.freecodecamp.org/agile/test-driven-development)

[freeCodeCamp Guide - Unit Tests](https://guide.freecodecamp.org/software-engineering/unit-tests)

[freeCodeCamp Guide - Continuous Integration](https://guide.freecodecamp.org/agile/continuous-integration)
