---
title: Design Patterns
---
## Design Patterns

Programmers and software architects use design patterns to solve **common, recurring problems** in software architecture. The patterns provide a language-agnostic approach to **object-oriented programming** that helps developers follow principles of good application design.

### Why Design Patterns?

Developing by design patterns offer several advantages:

* It's easier to follow good programming principles such as the **<a href='https://www.youtube.com/watch?v=XzdhzyAukMM' target='_blank' rel='nofollow'>SOLID</a> <a href='https://medium.com/@cramirez92/s-o-l-i-d-the-first-5-priciples-of-object-oriented-design-with-javascript-790f6ac9b9fa' target='_blank' rel='nofollow'>principles</a>.**
* It keeps code chunks smaller so code is easier to **test** and **debug**
* It helps keep code loosely coupled so code is easier to **re-use** and **update** for new applications
* It makes code easier to **understand**, so new contributors can **ramp up quickly**

Using design patterns incurs some trade-offs, and developers new to the practice should remember the following:

* There are **no silver bullets** in programming, and design patterns are not an exception
* Design patterns add a **layer of abstraction** to code which increases initial design and development effort
* Over-use of design patterns or forcing them to fit makes code **harder** to understand


### Language Support

Design patterns originated from the world of statically-typed languages like C++, Java, and C#. Most resources about development by design pattern are based in one of these languages. 

Nonetheless, design patterns are just that: patterns. They are **not implementations**, like classes or interfaces, and are **not constrained to any one language**. 

When learning design patterns within a dynamic language, if particular patterns seem needlessly complex or counter-intuitive, recall their origins. Developers in dynamic languages can still use and benefit from following design patterns, although more research may be required to fully understand them. 

### Uses

Design patterns are excellent at solving foundational coding problems in a simple and repeatable fashion. Broadly, they fall into three categories: 

* **Creational** patterns describe how to create new objects
* **Structural** patterns describe how to compose objects out of other objects
* **Behavioral** patterns describe how objects communicate with each other

These tasks can all be performed without design patterns, but design patterns **reduce the risk** that you will violate good practices and create code that is hard to maintain.

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->

* Kamran Ahmed's <a href='https://github.com/kamranahmedse/design-patterns-for-humans' target='_blank' rel='nofollow'>Design Patterns for Humans</a> is an excellent introduction to the specific patterns
* <a href='https://en.wikipedia.org/wiki/Design_Patterns' target='_blank' rel='nofollow'>Design Patterns</a> is the book that started this practice
* Martin Fowler's <a href='https://martinfowler.com/eaaCatalog/' target='_blank' rel='nofollow'>Patterns of Enterprise Application Architecture</a> provide a suite of more sophisticated patterns for enterprise applications
* Sourcemaking provides an <a href='https://sourcemaking.com/design_patterns' target='_blank' rel='nofollow'>online resource</a> with additional examples and information about design patterns
