---
title: Software Engineering
---
## Software Engineering

The field of **software engineering** is the application of techniques and strategies used to efficiently manage the entire life cycle of software development.  It involves solving real world problems and approaching the solution through computer programs.

If you are writing just scripts that might be used once or twice, implementing software engineering principles may be too involved. However, as software projects get larger and foresee future ongoing use, principles of software engineering become increasingly important.

The entire life cycle of software development ranges from the creation of ideas and design of the software to maintenance of the developed software over time.

You might think of software engineering as just how do you code up something and keep it going. However, an important aspect of software engineering you might not think about is the ethical practice of software development.

In this age where software can be used maliciously to steal information or do harm if software is implemented incorrectly, software engineers (or practitioners) must be aware of their duties to ethically develop software. 

### More Information:

- <a href='http://iansommerville.com/software-engineering-book/' target='_blank' rel='nofollow'>Software Engineering 10th Ed. by Sommerville</a> - website companion to the book with slide decks for each chapter
- <a href='https://www.computer.org/web/swebok' target='_blank' rel='nofollow'>The Guide to the Software Engineering Body of Knowledge</a>
- <a href='http://www.se-radio.net/' target='_blank' rel='nofollow'>Software Engineering Radio</a> - podcast for professional software developers
- <a href='https://softwareengineeringdaily.com/' target='_blank' rel='nofollow'>Software Engineering Daily</a>
- <a href='https://github.com/kilimchoi/engineering-blogs' target='_blank' rel='nofollow'>Curated List of Engineering Blogs</a>
- <a href='http://www.acm.org/about/se-code' target='_blank' rel='nofollow'>Software Engineering Code of Ethics and Professional Practice</a>
- <a href='https://en.wikipedia.org/wiki/Software_engineering' rel='nofollow'>Wikipedia Article</a>
