---
title: The Iron Triangle, or "Pick Two"
---
# The Iron Triangle, or "Pick Two"

Software development is a series of tradeoffs between features implemented, the quality of the features, and how long it takes to produce.
But, no matter how much effort is put in, one cannot sustainably maximize all three of these without increasing the cost of the project.
For software development, often cost is directly related to the number of people assigned to and working on a project. 
This concept is often summed up as "Pick Two: Quality, Speed, Features". 

This relationship between quality, features, speed, and cost is illustrated by imagining a triangle with a fixed volume 
with the volume being quality. 
One can increase speed to implement and the features, but quality will suffer if cost is unchanged, 
keeping the volume of the triangle the same.

Frequently cost is assumed to be constant because in most cases the cost is fixed and there is no budget to add more people 
nor are there people available for transfer from other projects.
![Illustration of Iron Triangle with Scope, Resources, Schedule, and Quality](http://www.ambysoft.com/artwork/ironTriangle.jpg)

----
## Sources:
* [The Broken Iron Triangle Anti-Pattern](http://www.ambysoft.com/essays/brokenTriangle.html) Classic essay by [Scott Ambler](https://en.wikipedia.org/wiki/Scott_Ambler)
