---
title: Version Control System
---
## Version Control System

Version control systems (VCS), also called Source Code Management (SCM), are tools used to track changes on files, manage version and ease collaborative file editing.
There are mainly 2 types of VCS:
- Centralized Version Control System 
Where a central repository is authoritative. The associate architecture is client/server.
The first VCS (CVS, SVN...) were Centralized Version Control System.
- Distributed Version Control System 
Where multiple repository exchange modification. The associate architecture is mostly peer to peer, but one repo can be declared as authoritative.
The most used modern VCS (Git, Mercurial...) are Distributed Version Control System.

### Why use it?
- **Changes history** - VCS enable the user to browse and search all the changes which are automatically recorded with useful information (date, author...) and
- **Versions/tags** - The user can search/retrieve specific state of the files that have been labeled with tags and version names
- **Branching/Merging** - Distributed Version Control System make it easy to maintain parallel branch of files and to merge them partially or totally when needed.
- **Atomic operations** - All modern VCS provide atomic operations: All modifications are guaranteed to succeed or fail as whole which ensure that the files are always in a consistent state.

### Most popular Version Control System

- Git

*Git* is a Distributed Version Control System and probably the most used VCS used nowadays with *Mercurial*.

- Mercurial

*Mercurial* is a Distributed Version Control System and probably the most used VCS used nowadays with *Git*.

- CVS

*CVS* is an old SCM which was proeminent before *SVN* widespread.
*CVS* and *SVN* are now deprecated in favor of Distributed Version Control System like *Git* and *Mercurial*.

- SVN/Subversion

*SVN* is an old SCM that succeeded *CVS*.
Eventually *SVN* was deprecated by the wide adoption of Distributed Version Control System like *Git* and *Mercurial*

### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
<a href='http://savannah.nongnu.org/projects/cvs' target='_blank'>CVS</a>

<a href='https://git-scm.com/' target='_blank'>Git</a>

<a href='https://www.mercurial-scm.org/' target='_blank'>Mercurial</a>


<a href='http://subversion.tigris.org/' target='_blank'>SVN</a>


<a href='https://en.wikipedia.org/wiki/Version_control' target='_blank'>Version Control on Wikipedia</a>

