---
title: Swift
---

![Swift Logo](https://developer.apple.com/assets/elements/icons/swift-playgrounds/swift-playgrounds-64x64_2x.png)

# What is Swift?

Swift is an [open source](https://en.wikipedia.org/wiki/Open-source_software), general-purpose programming language developed by Apple Inc. They describe it as:

> Swift is a powerful and intuitive programming language for macOS, iOS, watchOS and tvOS. Writing Swift code is interactive and fun, the syntax is concise yet expressive, and Swift includes modern features developers love. Swift code is safe by design, yet also produces software that runs lightning-fast.<sup>1</sup>

Want to try out Swift right now? [Repl.it](https://repl.it/languages/swift) offers an online Read-Eval-Print loop for Swift. You won't have access to UIKit or other APIs that are commonly used, but give it a shot!

# Basics

To declare a variable in Swift, simply use var followed by the name of your variable.
```Swift
var x = 6
var name = "Bob"
var boole = true

x = 3
```

Constants are similar to variables, but they cannot change in value after creation.
```Swift
let x = 6
let name = "Bob"
let boole = true
```

To print anything to the standard output, simply use print() and place your output in the parentheses.
```Swift
let x = "World"

print("Hello ")
print(x)
```



# Version

The latest version is [Swift 4.2](https://developer.apple.com/library/content/documentation/Swift/Conceptual/Swift_Programming_Language/RevisionHistory.html), released Sept. 17, 2018. Swift is constantly evolving, and you can expect more changes in the future. It is recommended you use the latest version of Swift when starting a new project.

# Documentation

Swift is heavily documented. Keep in mind that coding Swift involves not just
using the language, but also many APIs. The best way to learn Swift is to make a
project or application, no matter how small!

* [Source Code](https://github.com/apple/swift)

* [Developing iOS Apps (Swift)](https://developer.apple.com/library/content/referencelibrary/GettingStarted/DevelopiOSAppsSwift/): Want to make iOS Apps? This is a great place to start.

* [Language Guide](https://developer.apple.com/library/content/documentation/Swift/Conceptual/Swift_Programming_Language/): Has an overview of just about every feature in Swift. If you get confused when reading someone else's code, this document can help you.

# Want to learn more?

* [RayWenderlich.com](https://www.raywenderlich.com/) : Has many great tutorials for Swift and iOS development.
* [Hacking with Swift](https://www.hackingwithswift.com/read) : A complete Swift tutorial, taking you from a beginner to advanced using hands-on projects.
* [CodewithChris.com](https://codewithchris.com/xcode-tutorial/) : Xcode work environment education
* [Stanford course](https://www.youtube.com/watch?v=71pyOB4TPRE&list=PLPA-ayBrweUzGFmkT_W65z64MoGnKRZMq) : Excellent course held by the professor at Stanford university 
* [Basic app](https://developer.apple.com/library/content/referencelibrary/GettingStarted/DevelopiOSAppsSwift/index.html#//apple_ref/doc/uid/TP40015214-CH2-SW1) : Applying Swift knowledge in order to create a basic app that involves adding, listing, rating, deleting items
* [Main Swift documentation](https://developer.apple.com/library/content/documentation/Swift/Conceptual/Swift_Programming_Language/index.html): Good documentation regarding syntax
* [Main Swift book](https://itunes.apple.com/us/book/the-swift-programming-language-swift-4-0-3/id881256329?mt=11) : Main Swift book available on iTunes

### Sources

1. "Swift 4 - The powerful programming language that is also easy to learn." Apple, [developer.apple.com/swift](https://developer.apple.com/swift/), Accessed 31 Oct. 2017.

