---
title: Tailwind CSS
---
# Tailwind CSS

[Tailwind CSS](https://tailwindcss.com/) is a CSS framework following the "utility-first CSS" approach, a [term coined by Adam Wathan](https://twitter.com/adamwathan/status/1019206835335618560), who is one of the creators along with Jonathan Reinink, David Hemphill and Steve Schoger. Tailwind CSS is different from frontend libraries like [Bootstrap](https://getbootstrap.com) in the way that it does not provide a set of ready-to-use components. It rather comes with a curated but configurable set of CSS classes. This approach was [first described by Thierry Koblentz](https://www.smashingmagazine.com/2013/10/challenging-css-best-practices-atomic-approach/) and got known as "Atomic CSS", not to be confused with the "Atomic design" methodology.
Over the years the method of injecting CSS classes that are mostly applying only one single rule became more and more popular and was [thoroughly defended against criticism](https://frontstuff.io/in-defense-of-utility-first-css). While other frameworks use CSS utility classes as an addition, e.g. like [introduced in Bootstrap 4](https://getbootstrap.com/docs/4.1/utilities/), Tailwind CSS allows to create complex user interfaces merely using this technique.
The classes used in Tailwind CSS can be generated dynamically using a JavaScript configuration file which allows to adapt, add or remove classes. This includes adapting variables like color palettes or breakpoints used to generate the corresponding CSS classes.
Tailwind CSS is best suited for individually designed interfaces because it lacks components or a theme but instead gives the freedom to create a highly customized look without the need to override default styling. Nevertheless [custom components can easily be created](https://tailwindcss.com/docs/what-is-tailwind/#component-friendly) by applying the existing utility classes and to build common frontend components like [media cards](https://tailwindcss.com/docs/examples/cards).
