---
title: Source Code Editors
---

# Source Code Editors

Source code editors are the programs that allow for code creation and editing. Any text editor can be used to write code, but dedicated code editors offer many features useful for coding. This includes: code completion, syntax highlighting, and tabs/panes for side-by-side editing. These features can be useful even to new users who don't know their way around all of the advanced options.

There are many, many editors available to download or use online, both paid and free. They offer many of the same core features, but each have their own subtleties. Further research may help find the one that's right for you. The following editors are all cross-platform and free to use or evaluate.

## [Sublime Text](https://www.sublimetext.com/)<img src="https://i.imgur.com/3ALtws1.png" width="50px">
![Sublime Text Screenshot](https://i.imgur.com/Jk2aJod.png)

Sublime Text is a very popular editor that has been around [since 2008](https://www.sublimetext.com/blog/articles/one-point-oh). There are many options and [extensions](https://packagecontrol.io/search/sublime?sort=popularity) available, and a lot of [help available online](http://stackoverflow.com/search?q=sublime+text) to help set it up. Sublime Text is free to download and evaluate, but the license for continued use costs $70.

## [Brackets](http://brackets.io/)<img src="https://i.imgur.com/fassWYs.png" width="50px">
![Brackets Screenshot](https://i.imgur.com/H9mO8qS.jpg)

Brackets is a relatively new open-source editor by Adobe. It is very user  
friendly, especially for people who aren't used to command-line interfaces  
or JSON-style settings/preferences. Extensions and themes are quick and easy  
to find and install through the Extension Manager.

## [Atom](https://atom.io/)<img src="https://i.imgur.com/woj5vPm.png" width="50px">
![Atom Screenshot](https://i.imgur.com/halOgkj.png)

Atom is an [open source](https://github.com/atom/atom) editor, developed by [GitHub](https://github.com/). Atom is very popular and configurable("hackable", as they say), but the advanced features may be overwhelming to new users. There is also plenty of helpful documentation available online.

#### Atom resources:
- [5 Tips for getting started](http://readwrite.com/2014/05/20/github-atom-5-tips-getting-started-tutorial-corey-johnson/)
- [Atom flight manual](http://flight-manual.atom.io)
- [Atom on stackoverflow](http://stackoverflow.com/search?q=atom)

## [Visual Studio Code](https://code.visualstudio.com/)<img src="https://i.imgur.com/b4vFsKa.png" width="50px">
![Visual Studio Code Screenshot](https://code.visualstudio.com/home/home-screenshot-mac-lg.png)

Visual Studio Code is a source code editor developed by Microsoft since 2015, and is now one of the most known code editors.
It supports many programming languages, and like the others you can download plugins or extensions to make it more configurable for your coding style.

Its main features are:
*   IntelliSense - For syntax highlighting, autocomplete, functions definitions and smart complete.
*   Debugging - Be able to debug using break points, call stacks and an interactive console.
*   Built-in Git support - Review diffs, stage files, make commits, push and pull, all available in the editor.
*   Extensions - Install extensions to add new languages, themes, debuggers, and connect additional services.

**A few extensions that make your life easier and more interesting while using Visual Studio Code are:**
- [VS Live Share](https://marketplace.visualstudio.com/items?itemName=MS-vsliveshare.vsliveshare) - invite someone into your editor and code together
- [GitLens](https://gitlens.amod.io/) - helps visualize the code authorship
- [Visual Studio Keymap](https://marketplace.visualstudio.com/items?itemName=ms-vscode.vs-keybindings) - in case you switched to VS Code from Visual Studio
- [Debugger for Chrome](https://marketplace.visualstudio.com/items?itemName=msjsdiag.debugger-for-chrome) - if you are using Google Chrome browser too
- [Auto Close tag](https://marketplace.visualstudio.com/items?itemName=formulahendry.auto-close-tag) - automatically adds HTML/XML close tag
- [Auto rename tag](https://marketplace.visualstudio.com/items?itemName=formulahendry.auto-rename-tag) - automatically rename paired HTML/XML tag
- [ESLint](https://marketplace.visualstudio.com/items?itemName=dbaeumer.vscode-eslint) - for making sure your code conforms to ESLint formatting
- [Path Intellisense](https://marketplace.visualstudio.com/items?itemName=christian-kohler.path-intellisense) - autocompletes filenames
- [TODO highlight](https://marketplace.visualstudio.com/items?itemName=wayou.vscode-todo-highlight) - Highlight TODO, FIXME and other annotations within your code
- [Code Snippets](https://marketplace.visualstudio.com/search?term=snippets&target=VSCode&category=All%20categories&sortBy=Relevance) - snippets for anything you need
- [A collection of awesome VS Code extensions](https://github.com/viatsko/awesome-vscode)

## [Notepad++](https://notepad-plus-plus.org)<img src="https://upload.wikimedia.org/wikipedia/commons/0/0f/Notepad%2B%2B_Logo.png" width="50px">

Notepad++ is a free, open source code editor, that runs in the Microsoft Windows Environment. It was developed in 2003, by Dan Ho. It is written in <a href='www.cplusplus.com' target='_blank' rel='nofollow'>C++</a> (the name comes from that). Notepad++ supports tabbed editing, wich allows working with multiple open files in a single window, and also can be use as a plain text editor.

