---
title: TypeScript
---
## TypeScript

### Overview

![TypeScript](https://i.imgur.com/uRLunzU.png)

So as you are most likely aware, JavaScript is expanding its footprint everyday and it is both overwhelming and amazing what you can do with the language nowadays.

However, as more large-scale projects start to use JavaScript, the process of making the code easier to write and more maintainable becomes more and more difficult. One reason for this is that, unlike some other programming languages, JavaScript is not a strongly-typed language. This means there can be confusion, especially in large code bases, about when different types (numbers, strings, booleans, arrays, etc) should be used and sometimes the problems only surface in production.

This is a problem Microsoft recognized early on and they came up with the solution of TypeScript and released the first version on October 1st, 2012.

You can learn more about the syntax differences at [`TypeScript`](./) > [`JavaScript vs TypeScript`](./javascript-vs-typescript).

![Key Features](https://i.imgur.com/pZij95O.jpg)

### Version

Latest stable version available is [TypeScript 3.1](https://www.typescriptlang.org/docs/handbook/release-notes/typescript-3-1.html).

### Installation

To learn more about installation, see [`TypeScript`](./) > [`Installation`](./installation).

### Linter

To learn more about using a linter with TypeScript, check out [`TypeScript`](./) > [`Linter`](./linter).

### Playground

![Playground](https://i.imgur.com/vlV7ZFr.png)

If you want to try out TypeScript without installing it, visit the <a href='http://www.typescriptlang.org/play/index.html' target='_blank' rel='nofollow'>TypeScript Playground</a>.

The Playground has a built-in auto completion and the ability to directly see the emitted JavaScript.

### Other Resources

To learn more about installation, see the [Installation Appendix](./src/articles/typescript/appendix-installation/index.md).

In case you need just a type checker and don't want to compile your program, read about <a href='https://facebook.github.io/flux/' target='_blank' rel='nofollow'>Flux</a>.

- <a href='http://www.typescriptlang.org/samples/index.html' target='_blank' rel='nofollow'>Quick Start</a>
- <a href='http://www.typescriptlang.org/docs/home.html' target='_blank' rel='nofollow'>Documentation</a>
- <a href='https://github.com/Microsoft/TypeScript' target='_blank' rel='nofollow'>Source Code</a>
- <a href="https://www.tutorialspoint.com/typescript/" target="_blank">TutorialsPoint</a>
