---
title: Alignment
---
## Alignment

Typographic alignment alters the flow of text in a document. Designers can use this powerful tool to subtly enhance the presentation of text by giving it visual form and context.

Experiment with alignment to find exciting new visual combinations that make your content stand out. Be sure to test for alignment errors on different devices and browsers.

Use CSS to align text whenever possible. You may encounter HTML alignment tags (e.g., `<p align="right"></p>` or `<center></center>`), but they are deprecated in HTML 5.

There are four main ways to align a paragraph, which we'll discuss in further detail below: Flush Left, Flush Right, Justified, and Centered. There are various factors to look at to determine which alignment will work best for your application.

### Left-justified Text

Default, `text-align: left;`

When in doubt, the default kind of text justification is usually the best choice. Especially for articles or long blocks of text, left-justified text is easiest to read, as the ragged edges on the right provide visual context to help readers keep their place as their eyes shift from line to line.

Use for:
* Body text
* Most everything else

### Right-justified Text

`text-align: right;`

Right-justified, left-ragged text can be useful as a visual spice but is more difficult to read in long stretches than left-justified text.

Can be used for:
* Captions
* Navigation
* Sidebars
* Quotations

### Centered Text

`text-align: center;`

Use centered text to pull readers' eyes to points of emphasis (e.g., headings, page titles, footers). Do not use centered text for long blocks of text, as it is extremely exhausting to read.

Can be used for:
* Headings
* Page title
* Navigation
* Sidebars
* Captions
* Quotations
* Footers

### Justified Text

`text-align: justify;`

Full-justified text is tricky to recommend for body text, as large gaps can appear between words in some lines. However, skilled designers can make beautiful use of it.

Can be used for:
* Captions
* Sidenotes

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
* [Wikipedia Article](https://en.wikipedia.org/wiki/Typographic_alignment)
* [Web Style guide](https://webstyleguide.com/wsg2/type/align.html)
* <a href="http://www.webpagemistakes.ca/text-alignment-on-the-web/" rel='noopener noreferrer'>Text Alignment on the Web</a>
