---
title: Anatomy of Letterforms
---

## Anatomy of Letterforms
The anatomy of Letterforms describes the different elements that make up printed letters in a typeface. The figure below shows the different parts of the letters in a typeface.

![alt text][logo]

[logo]: https://upload.wikimedia.org/wikipedia/commons/a/a3/Typographia.svg

>Parts of a glyph: 1) x-height; 2) ascender line; 3) apex; 4) baseline; 5) ascender; 6) crossbar; 7) stem; 8) serif; 9) leg; 10) bowl; 11) counter; 12) collar; 13) loop; 14) ear; 15) tie; 16) horizontal bar; 17) arm; 18) vertical bar; 19) cap height; 20) descender line.

A typeface broadly consist of 3 different parts 1) **Strokes** 2) **Terminals** 3) **Space**

#### Strokes
Stroke refers to the main body of the letterform. They may be straight, as in letters like _l_, _z_, _k_, _v_ or curved like in _c_ or _o_. The different parts of the stroke are given below

* The imaginary line on which most characters sit is known as the **Baseline** (4).

* The capheight or **capline** (19) is another imaginary line depicting the height of all the uppercase alphabets.

* The imaginary horizontal line that marks the top edge of the lowercase letters is the **Meanline**.

* The **x-height** (1) is the height of the lowercase x. In other words it is the distance between the baseline and the meanline.

* The main vertical or diagonal stroke in a letterform is known as the **Stem** (7).

* The strokes that connect two lines in the capital letterforms of *A* and *H* or cross strokes in *t* is known as **Crossbar** (6).

* When the stroke of a lowercase letter rises above the meanline like in _l_ it is called an **ascender** (5). The **Ascender line** (2) is the imaginary line depicting the distance between the baseline and the top of the ascender.

* When the stroke of a lowercase letter falls below the baseline like in _g_ it is called a **descender**. The **Descender line** (20) is the imaginary line depicting the distance between the baseline and the bottom of the descender.

* An arching stroke as in the top of an _R_ is called a **Shoulder** or sometimes just an _arch_, as in _h_, _n_, _m_.

* A closed curved stroke is called a **Bowl** (10).

* The inferior diagonal stroke seen in _K_ and _R_ is called **Leg** (9).

* A short horizontal stroke seen in the center of _e_, _f_ and in the middle stroke of _E_ and _F_, is called a **Bar**.

* The longer horizontal Stroke on the top or bottom as seen in _E_ and _F_ is called the **Arm** (17).

* The dot above the lowercase _j_ and _i_ is called the **Tittle** or dot or a jot.

* The bottom part of the two-story _g_ is called a **Loop** (13).

#### Terminals
Terminals are the end of the strokes. They are of two types **Serif** and **Sans-Serif**. A seriffed terminal has proftusions on the edges which can be described as a wedge, bulbous, teardrop, slab, etc. Sans-Serif on the other hand does not have these extending features at the end of strokes. Sans-Serif is used often on digital displays these days since they have better legibility on lower resolution displays where serifs are hard to display.

#### Space
Space refers to the white space that is found between the letters and also inside letters like _o_ and _p_ with closed loops.

Below are some basic definitions to help you understand how type is described and measured.

## Typeface
A typeface refers to a group of characters, such as letters, numbers, and punctuation, that share a common design or style. Times New Roman, Arial, Helvetica and Courier are all typefaces.


## Font
Fonts refer to the means by which typefaces are displayed or presented. Helvetica in movable type is a font, as is a TrueType font file.

![The Anatomy of Typography](https://www.canva.com/learn/wp-content/uploads/2015/07/typography-terms-infographic-tb-800x0.png)

## Type Families
The different options available within a font make up a type family. Many fonts are at a minimum available in roman, bold and italic. Other families are much larger, such as Helvetica Neue, which is available in options such Condensed Bold, Condensed Black, UltraLight, UltraLight Italic, Light, Light Italic, Regular, etc.

## Serif Fonts
Serif fonts are recognizable by the small lines at the ends of the various strokes of a character. As these lines make a typeface easier to read by guiding the eye from letter to letter and word to word, serif fonts are often used for large blocks of text, such as in a book. Times New Roman is an example of a common serif font.

## Sans Serif Fonts
Serifs are small lines at the ends of character strokes. Sans serif, or without serif, refers to typefaces without these lines. Sans serif fonts are often used when a large typeface is necessary, such as in a magazine headline. Helvetica is a popular sans serif typeface. Sans serif fonts are also common for website text, as they can be easier to read on screen. Arial is a sans serif typeface that was designed specifically for on-screen use.

## Point Sizes
The point is used to measure the size of a font. One point is equal to 1/72 of an inch. When a character is referred to as 12pt, the full height of the text block (such as a block of movable type), and not just the character itself, is being described. Because of this, two typefaces at the same point size may appear as different sizes, based on the position of the character in the block and how much of the block the character fills.

## Pica
The pica is generally used to measure lines of text. One pica is equal to 12 points, and six picas are equal to one inch.

## Baseline
The baseline is the invisible line on which characters sit. While the baseline may differ from typeface to typeface, it is consistent within a typeface. Rounded letters such as "e" will extend slightly below the baseline.

## X-height
The x-height is the distance between the meanline and the baseline. It is referred to as the x-height because it is the height of a lowercase "x." This height can vary greatly between typefaces.

## Tracking, Kerning and Letterspacing
The distance between characters is controlled by tracking, kerning and letterspacing. Tracking is adjusted to change the space between characters consistently across a block of text. This may be used to increase legibility for an entire magazine article. Kerning is the reduction of space between characters, and letterspacing is the addition of space between characters. These smaller, precise adjustments may be used to tweak a specific word, such as in a logo design, or a large headline of a story in a newspaper. All of the settings may be experimented with to create artistic text effects.

## Leading
Leading refers to the distance between lines of text. This distance, measured in points, is measured from one baseline to the next. A block of text may be referred to as being 12pt with 6pts of extra leading, also known as 12/18. This means there is 12pt type on 18pts of total height (12 plus the 6pts of extra leading).

Baseline: The imaginary horizontal line that a majority of letters rest on.

Cap height: The imaginary horizontal line that marks there all capital letters end at the highest point.

Crossbar: The horizontal line that connects two other lines in a letter such as "A" or "H".

Counter: The negative space inside a letter. The counter can be fully enclosed like letters "O" or "A", or partially enclosed like letters "C" or "U".

Descender: The imaginary horizontal line that marks the lowest point of special lowerclase letters such as "g", "j", "p", "q", and "y".

Leg: The lower angled stroke in letters such as "K", "R", and "Q".

Mean line: The imaginary horizontal line that marks the top point of lowercase letters.

Serif: The finishing stroke at the end of the text that creates a "foot" appearance.

Stem: The main vertical stroke in a letterform. This can also be diagonal like in letters "W" or "N".

Tittle: The dot above the lowercase letters such as "i" and "j".

Letterform broadly refers to a letters shape and includes typography. Typography is the apperance of printed letters. In order to understand typography requires a certain vocabulary. By learning the terms of typography, you can also become more critical viewer of printed type.

#### More Information:

* [Wikipedia](https://en.wikipedia.org/wiki/Typeface_anatomy)
* [Sitepoint](https://www.sitepoint.com/the-anatomy-of-a-letterform/)
* [Typomil](http://typomil.com/anatomy/index.html)
