---
title: Choosing a Typeface
---
## Choosing a Typeface

Form follows function: work from general principles, don't choose typefaces at random.

### When You Can't Choose

When choosing a different typeface is out of the question, you can often still add visual spice to a project by tweaking font sizes, weights, and styles. Furthermore, it is always better to try hit-and-miss strategy, trying a few different fonts before you give up on choosing another typeface. This way, maybe you won't get your desired typeface but you'll have an idea of various other typefaces you could then use in another cases.

### When You Can

#### Appropriate Application

You don't want to stand out in a bad way. The needs of your project often constrain your creative choices: company branding guidelines, download and rendering time, Operating System defaults, accessibility, browser support, etc.

Search for real-life examples of projects like yours to get an idea what typefaces or styles are typical. Designers honed those norms through years of testing and careful consideration.

#### Working Together

Carefully choose contrasting fonts (e.g., Minion and Myriad) and weights (e.g., bold and regular). Avoid using too many or too-similar fonts. More than three typefaces on a single page should give you pause - often either the content is too complex for a single page or the design is noncohesive.

Learn the most common font types (Geometric Sans, Humanist Sans, Oldstyle, Transitional and Modern, Slab Serifs)<sup>1</sup> and how they interact, and you will be able to more knowledgeably manipulate multiple typefaces together.

#### Break the Rules

In the end, guidelines can only take you so far. Creativity and surprise are important components of design work. As much as you pay attention to standards and convention, pay attention to outliers. Study how and why they break the rules to inform your own rule-breaking.

## Tips for quickly choosing a Typeface
* Plan Your Hierarchy
* Consider What Others Have Done Already
* Experiment the Easy Way
* Avoid Anachronisms
* Avoid Trite Correlations
* Consider an Extended Type Family
* Stick With the Classic Combinations
* Use a Limited Palette

#### Sources

1. Dan Meyer, [What Font Should I Use? 5 Principles for Choosing and Using Typefaces](https://www.smashingmagazine.com/2010/12/what-font-should-i-use-five-principles-for-choosing-and-using-typefaces/), smashingmagazine.com, 2010.

#### More Information:

* [20 Perfect Type Pairings](http://www.creativebloq.com/typography/20-perfect-type-pairings-3132120)
[Choosing the Right Font - A concise article for reference](https://webdesign.tutsplus.com/articles/choosing-the-right-font-a-practical-guide-to-typography-on-the-web--webdesign-15?_ga=2.210603089.55465761.1538586153-769794395.1538586153)
* [Smashing Magazine article - How to choose a typeface](https://www.smashingmagazine.com/2011/03/how-to-choose-a-typeface/)

