---
title: Combining Typefaces
---
## Combining Typefaces

#### Font Pairing Basics

Which fonts look good together and which ones don't? If you've ever struggled with this question, you're not alone. Learn how to pair different fonts and styles by getting familiar with these clever combos!

#### Try these steps one by one

* Pair a regular and bold font to create a subtle contrast
* Balance a script font with a bold font
* Pair a tall and short font to create visual interest
* Pair fonts with different weights to create a strong contrast
* Pair a regular and italic font to create emphasis
* Pair a serif and sans-serif typeface with similar x-heights

There are no hard and fast rules for choosing typefaces, but you can often avoid having to choose new typefaces by styling an existing typeface to create a visual hierarchy. When in doubt, keep it simple.

Designers follow different philosophies to determine when and how to combine typefaces.

### Anchor<sup>1</sup> or Role Typeface

If your project involves large amounts of text, choose an anchor typeface for the body text. This anchor typeface will guide the rest of your design choices as you make continuous tests and refinements for different combinations of typefaces against your anchor.

### Contrasting Typefaces

For text-light projects, having clear hierarchical roles for a font is not as great a concern as visual impact. Pair contrasting typefaces such as serif plus sans-serif. Designers often share their favorite typeface pairs, so search and experiment until you create a pleasing result.

### Typeface Families

Many type foundries create typefaces with extensive extra features like multiple weights and cases, decorative glyphs, serif and sans-serif versions, etc. You can use a single type family like this to ensure consistent design while creatively using those extra features to provide extra emphasis or decoration that might otherwise require another typeface. Typeface families are often a great compromise of visual consistency and typographic flexibility.

#### Sources

1. Tim Brown, [Combining Typefaces: A Pocket Guide](https://blog.typekit.com/2016/04/29/combining-typefaces-free-guide-to-great-typography/), PDF.

#### More Information:

* Shaun Pagin, [The Art Of Mixing Typefaces Google Fonts Edition](http://www.fastprint.co.uk/blog/the-art-of-mixing-typefaces.html).

* Jermiah Shoaf, [Type Pairing Lookbooks](https://www.typewolf.com/lookbooks)
