---
title: Type Classifications
---
## Type Classifications

Almost all typefaces fall into one group or another. This system of classifying typefaces developed in the nineteenth century. Each typeface has it's own visual structure, influences, intent and historical significance.

The basic classification of typefaces is as follows:
* **Serifs**: These typefaces have small extensions, which embellish the basic structure of a typeface. Serif typefaces have existed since the beginning of type. They are visible in Old style and Humanist type serifs like Garamond. Baskerville, another serif typeface belongs to the transitional era. Bodoni and Rockwell are part of Modern and Slab serif(Egyptian) styled typefaces. 
* **Sans-serif** : Sans means without. These typefaces are devoid of those small extensions, hence without serif. Examples include Gill sans which has Humanist connotations, Helvetica with it's transitional characteristics and so on. 
* **Script**: Letter forms developed in close relation to human handwriting are script typefaces. They are flexible in nature with varying stroke widths. Example : Bistro Script, Shelly, Minstral etc.
* **Blackletter** : A bold script style of calligraphy used heavily during the renaissance.  Example: Fraktur
* **Decorative**: Typefaces which do not fit in other categories are decorative in nature. Built for specific use cases which largely consist of headlines, posters etc. 

 In addition, three main groups to classify type corresponding to different time periods in art and literature are as follows: 

* **Humanist** letter forms belong to the renaissance period of around 15th & 16th century. They closely mimic calligraphy and human hand movement. Old serifs followed humanist letter forms. Examples of humanist type are : Sabon, Centaur, Adobd Jenson, Gill Sans etc. 
* **Transitional** letter forms are part of the baroque era. They represent a transition from old style humanist typefaces to modern typefaces.  Examples are : Baskerville, Times Roman, Helvetica etc.
* **Modern**  letter forms, are part of the enlightenment period of around 18th-19th century. They depict a radical shift from traditional typography to a more abstract design. Examples are : Bodoni, Futura etc.

![Image of Type Classification](http://thinkingwithtype.com/images/Thinking_with_Type_Letter_12.gif) <br>
> Image taken from the online version of the book Thinking with Type by Ellen Lupton

#### More Information:
 * [Type Classification](http://www.designishistory.com/1450/type-classification/) Design History
 * [Vox-Atypl Classification](https://en.wikipedia.org/wiki/Vox-ATypI_classification) Wikipedia
 * [Thinking with Type](http://thinkingwithtype.com/letter/#type-classification)
 * [Type Classification - 6 part series](http://ilovetypography.com/2007/11/06/type-terminology-humanist-2/) I love Typography


