---
title: Typeface
---
## Typeface

In modernday web-design the word "font" came to define what is actually called "typeface" in professional design world. In fact, typeface means something that we know as distinctive style of font-family: a specific shape of letters (professionally known as glyphs), based on which different fonts are generated by means of adding font-weight (bold, semi-bold, etc.) or making the letters italicised and so on. 

To give a simple example, all of the different fonts on the image below belong to the same typeface called "Futura" but different styling of the letters with the same shapes (glyphs) produces different visual effect for each font.

![Futura typeface](https://dab1nmslvvntp.cloudfront.net/wp-content/uploads/2009/10/Futura.gif)

Image courtesy of [Sitepoint.com](https://www.sitepoint.com/typography-concordant-contrasting-conflicting/)

Most common typeface styles include:

  * Serif
  * Monospace
  * Script

**Beginner-designer tip:** While script fonts, such as brush fonts or calligrahpy and handwritten, might be truly trendy in web-design right now, bad combination of fonts can truly ruin otherwise good aesthetics of the page. Therefore, try to avoid mixing in two many fonts. In fact, do not even go for two! Start with one typeface (i.e. font-family) which offers several styles (fonts). This will guarantee that the fonts you use will blend in well together. Use bold version for main headers and light version for text. When you feel secure with your designer choice of matching font-types, feel free to try and mix your own font pairings.


<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
[Web Style Guide - Typefaces](https://www.webstyleguide.com/wsg3/8-typography/4-web-typefaces.html)

