---
title: Typographic Hierarchy
---
## Typographic Hierarchy
A webpage itself has a hierarchy that not only is read, but contains interaction. The page as a whole must be designed in a way that clearly communicates to the user what actions are available and how to easily access the information they seek, how to purchase an item, etc.

For the purpose of this article, however, we’re talking strictly about hierarchy as it applies to type. Luckily for us, we have our own handy HTML tag that lets us semantically establish typographic hierarchy into the websites we build. Heading tags (H tags) allow us to specify an order of importance into our content: H1 through H6, H1 being most important, H6 being least. Search engines use this data to interpret priority of content on a webpage.The H tag can be styled by using the following attributes.

- Size
This is the easiest and most common method for establishing hierarchy.

- Weight
Simply using a bolder weight of a font can help isolate.

- Color
Color plays a big role in what our eye sees as primary and secondary. Generally speaking; warm colors pop, cooler colors recede.

- Position
Where sections of information are positioned in relationship to each other can establish a hierarchy.

- Type Contrast
A great way to achieve hierarchy is to use contrasting typefaces.

- Spacing
One of the most important concepts in type design is spacing. It’s one of the most difficult concepts to grasp for beginning designers, yet it is also one of the most visually obvious. Proper typographic spacing is critical in establishing hierarchy; it can make the difference between confusion and clarity. It is used in the majority of hierarchical systems, and it is present in all of the examples in this article.

#### More Information:
[webdesign.tutsplus.com - Understanding Typography Hierarchy](https://webdesign.tutsplus.com/articles/understanding-typographic-hierarchy--webdesign-11636)


