---
title: Upper and Lower Case
---
## Upper and Lower Case
Uppercase (UC) is alternatively referred to as caps and capital. It is a typeface of larger characters. Lowercase (LC) is a typeface of small characters. As long as the shift key is not being pressed and the Caps lock is not active, everything typed is in lowercase. The Uppercase and Lowercase is often synonymous with Majuscule and Minuscule.

Many languages have two different written representations of their letters, **upper case** and **lower case**, also known as majuscule and minuscule forms. 

Upper case and lower case letters are often mixed in the same piece of text. The use of cases is decided by grammar, but a variety of [case styles](https://en.wikipedia.org/wiki/Letter_case#Case_styles) also exists. 
Certain case styles are common in computer programming, referred to as [naming conventions](https://guide.freecodecamp.org/javascript/naming-convention-for-javascript), like camelCase and snake_case.

## Uppercase:
A B C D E F G H I J K L M N O P Q R S T U V W X Y Z

## Lowercase:
a b c d e f g h i j k l m n o p q r s t u v w x y z

Capitalization is important for the following reasons:
- Passwords: passwords are case sensitive, so capitalization add an extra level of security.
- Measurements: When dealing with computer measurement, and other measurements, capitalization is important for identifying the exact type of measurement. For example, "Mb" (short for Megabit) and "MB" (short for Megabyte) are two different types of measurements with different values.
- Commands 
- File names, directories and paths.

#### More Information:
<a href='https://www.computerhope.com/jargon/u/uppercase.htm'>Computer Hope</a> <br>
<a href='https://www.computerhope.com/jargon/l/lowercas.htm'>Computer Hope</a> <br>
<a href='https://en.m.wikipedia.org/wiki/Letter_case'>Wikipedia</a>
