---
title: Hicks Law
---
## Hicks Law
Hick’s law states that the time it takes to make a decision increases as the number of alternatives increase. It's named after British and American psychologists William Edmund Hick and Ray Hyman. 

### Understanding Hick's Law with an Example
Do you remember the old video games from over 20 years ago, and how much fun it was to play them? The controls were so simple you could learn to play in seconds. For example, Super Mario with just left, right, and jump controls.

In comparison, today’s input controls of modern gaming consoles and PC games have many choices and combinations. All these controls multiply the available options that a user can choose in any certain situation.

Having so many options makes learning the game and enjoying it much harder and time-consuming.  

### What it means in UX Design
Hick’s law can be used to narrow down big volumes of information without overloading the user. When you need to simplify a complex process, use Hick’s law. Present specific parts of that process at any one time on the screen.

An example can be a payment process. Instead of showing everything at once, you can break it down. Show the screen with shopping cart details, then another with delivery information, then optional account creation, and so on.

Reducing the number of perceived options on the screen makes the interface more user-friendly. It is also more likely that the user will accomplish the goal and not give up or get confused.

**It is important to point out not to oversimplify!** Breaking down choices to a series of too many small chunks can also cause the user to drop off before reaching the goal.

### More Information:

Hicks' Law - <a href='https://en.wikipedia.org/wiki/Hick%27s_law' target='_blank' rel='nofollow'>Wikipedia</a>

Design Principles: Hick's Law - <a href='https://uxplanet.org/design-principles-hicks-law-quick-decision-making-3dcc1b1a0632' target='_blank' rel='nofollow'>uxplanet</a>

Good UI (75 patterns tested by A/B Tests) - <a href='https://goodui.org' target='_blank' rel='nofollow'>UI screens get better when backed by A/B Tests</a>

Understanding Hick's Law - <a href='https://www.youtube.com/watch?v=OU7ekX05UEU' target='_blank' rel='nofollow'>Youtube</a>
