---
title: Human Computer Interaction
---
## Human Computer Interaction
Human-Computer Interaction (HCI) is a field of study that focuses on the design of computer technology and, in particular, the interaction between humans
(the users) and computers. It encompasses multiple disciplines, such as computer science, cognitive science, and human-factors engineering. While it originally
concerned computers, HCI has since expanded to cover almost all forms of information technology design.

Humans interact with computers mostly through graphical user interfaces (GUI), and sometimes through voice user interfaces (VUI).  In the field of User
Experience/User Interaction (UX/UI), human-computer interaction is studied to ensure optimal user satisfaction and engagement with a piece of software.

### Design Principles
Several experimental design principles can be applied to designing or evaluating a user interace:

* Early focus on user and task: Establish how many users are needed to perform the task(s) and determine who the appropriate users should be; someone who has never used the interface, and will not use the interface in the future, is most likely not a valid user. In addition, define the task(s) the users will be performing and how often the task(s) need to be performed.
* Empirical measurement: Test the interface early on with real users who come in contact with the interface on a daily basis. Keep in mind that results may vary with the performance level of the user and may not be an accurate depiction of the typical human-computer interaction. Establish quantitative usability specifics such as: the number of users performing the task(s), the time to complete the task(s), and the number of errors made during the task(s).
* Iterative design: After determining the users, tasks, and empirical measurements to include, perform the following iterative design steps:
  1. Design the user interface
  2. Test
  3. Analyze
  4. Repeat

### Relation to User Experience Design (UX)
In many ways, HCI was the forerunner that would grow to become what we now call “User Experience (UX) Design.” Despite that, some differences persist between HCI and UX design. Practitioners of HCI tend to be more academically focused, and are involved in scientific research and developing empirical understandings of users. UX designers, on the other hand, tend to be industry-focused, and most UX designers are involved in building a product or service—for example, a smartphone app or a website. Regardless of this difference, the practical considerations for products that UX designers concern themselves with have direct links to the findings of HCI specialists about the mindsets of users. Due to this, there is little point in separating these realms to any great extent.


#### More Information:
- [Human Computer Interaction (Wikipedia)](https://en.wikipedia.org/wiki/Human–computer_interaction)
- [The Encyclopedia of Human-Computer Interaction, 2nd Ed.](https://www.interaction-design.org/literature/book/the-encyclopedia-of-human-computer-interaction-2nd-ed/human-computer-interaction-brief-intro)
