---
title: Information Architecture
---
## Information Architecture

Information Architecture, or IA, is usually undertaken by a User Experience (UX) professional with a background in thebroader discipline of UX. (IA is a part of UX). This is not a creative/visual design undertaking but one that is more focused on information design, user task flows and scenarios, use cases, content design, information hierarchy.  

The types of documents one produces in the practice of IA are typically refered to as sitemaps (different from flow charts), feature maps, content maps and inventories (although these can also be created by content editors). The IA also cares about the actual verbiage used throughout the navigation and content of the site or product, aiming for clarity and consistency. You'll see reference to 'customer journeys,' but this is not UX or IA – it's something else altogether. 

It helps to know where IA sits within the schema of the team and other documentation. The high-level flow of project documentation and process looks like this: (note: assume client signs off at multiple points in the process)
1. Discovery Phase & kickoff: project brief, requirements gathering (technical, functional, creative/brand, content).
2. UX-IA Phase: research > personas > user flows > sitemaps > wireframes. Interaction design details are worked through and finalized. If prototypes are scoped (in budget), sample protos are produced reflective of the user flows and interaction design, and the creative if/when it's ready per the schedule.
3. Creative Deisgn: rough mockups (informed by all the documentation up to this point), high-fidelity mockups (with more accurate final art and content), production-ready art assets produced and delivered to dev.
4. Dev has been working behind the scenes, usually agile or agile-fall in methodology. Dev, UX and creative collaborate on various aspects of the project at any given time. They all know what eachother needs and is expecting from the other.<BR>
(This is a general overview of how a multi-disciplinary team would operate. There are many variables that affect process. Ultimately, the best process is one that the team and client can articulate and stick to, and that produces the desired end result.) 

IA is a critical discipline within the digital product/experience creation process. When done well, it is transparent and unnoticable. When done poorly, it dissolves client trust in the team, leads to extra work/time/money spent, possible delays in deliverables and if not caught before shipping/launch, it can embarrass the client to their target audience – not good for the production team.

## Other Resources

- [Information architecture - Wikipedia](https://en.wikipedia.org/wiki/Information_architecture)
- [Usabilty.gov](https://www.usability.gov/what-and-why/information-architecture.html)


