---
title: Moodboards
---
## Moodboards

Moodboards are a way to convey the feeling about product you are about to make. Also to get inspiration for colour palette and shapes to use later. In other words, moodboard is <a href="http://www.creativebloq.com/graphic-design/mood-boards-812470">a collection of textures, images and text related to a design theme as a reference point</a>.

Creating a moodboard is really simple. There are two ways: either manual or digital.

For creating manual moodboards you will need: 
- Different magazines, newspapers, books and/or posters that you can cut 
- Paper
- Scissors
- Glue 

Start out with finding the images, shapes, colours, messages you feel that resonate with your will-be product. 
Cut them out. 
If you have cut out all that you need, arrange them on paper, and glue them.
The end result might look something similar to this:

![papercut moodboard](https://raw.githubusercontent.com/ejke/ejke.github.io/master/else/moodboard.jpg)


The other option is to create digital moodboard. The technique is quite the same, you need:
- Internet connection
- Basic knowledge of copy and paste functions
- Image editing software

The positive aspect is that you don't have to limit your moodboard to images in magazine. The negative aspect is that it might be hard to find the right images, since you have all internet to search from. 

The places to start look for images and ideas:
- <a href="https://images.google.co.uk/">google</a>. Google Images can be chosen according to colour, shape or form, so if you can search it, then it is possible that you find it.
- <a href="https://www.pinterest.dk/">Pinterest</a>. Same as for google, yet different.
- free images. Such as <a href="https://pixabay.com/">Pixabay</a>, <a href="https://www.pexels.com/">Pexels</a>, or <a href="http://www.freeimages.com/">free images</a> sites, you can find tons of inspiration already in one picture.
- go outside with a camera. There might be the exact item for your moodboard waiting for you to take that picture. 

Again, when you have sufficient images, it is time to put the moodboard together. For that, you also have different possibilities:
- Gimp/Photoshop/Paint. In first two you have greater ability to move images around, paint is just as good as paint can be (sufficient, but uncomfortable).
- Inkscape/Illustrator. These are not ment for this kind of work, but can do the job. Additionally you have do and add vector art to your moodboard.
- Online tools: just search for 'moodboard' with your favourite search engine and you should find plenty of sites that offer the template for competing moodboard.

![digital moodboard example](http://stuckwithpins.com/blog/wp-content/uploads/2015/08/moodboard-s2s.jpg)


Note: 
When creating moodboards, try to avoid using titles or pictures of the thing you are creating moodboard for. 

For example, when creating moodboard for Harry Potter website, do not use picture of actors nor write down the title. Usually it is not the best way. Instead, find thematicly dark colours, wood and stone textures, picture of lightning bolt, another person with round glasses (not a fan dressed up), loads of books stacked on top of each other, boiling cauldron, etc. It might seem hard in the beginning, but it gives more inspiration on the later stages of production - and you might need that inspiration then. 

Making moodboards is one of the most fun part of production, so try to enjoy it and get creative!

Mood boards can convey color scheme, type face, and specific imagery.  They can also explore tone and mood more abstractly.  A board can include video or sound in addition to static images, photography, and text.

![An example of a surf-themed mood board](https://cdn-images-1.medium.com/max/1600/1*9qVOw8uDg8oOOevWmYUozQ.jpeg)

There are many factors that go into making the perfect mood board. Depending on your audience, you may want to decide on choosing a larger image and building the mood board around it. This image would become your inspiration and centerpiece for the entire board. Also, do you think you should create a physical or digital mood board, which one would portray your ideas and inspiration more effectively?

![An example of a physical mood board](https://www.designyourway.net/blog/wp-content/uploads/2018/02/06moodboard3-superjumbo.jpg)

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
<a href='https://uxplanet.org/creating-better-moodboards-for-ux-projects-381d4d6daf70'>Milanote. "Creating Better Moodboards for UX Projects." <i>Medium</i>.  September 10, 2017.  Accessed: October 25, 2017.</a>


