---
title: Pattern Libraries
---
## Pattern Libraries

A pattern library is a collection of reusable user interface design elements. Since these ui elements are reused multiple times in a website, web application, or software application, they impose structure through consistency. This makes the site or app easier to use.

A few common ui elements found in a pattern library are:
* Menus
* Buttons
* Page Layouts
* UI Animations
* Forms


### Benefits of Pattern Libraries

Paul Boag, from his blog [Boagworld.com](https://boagworld.com/design/pattern-library/), explains the main reasons for creating a pattern library:
1. "A pattern library ensures a consistent user interface."
2. "A pattern library facilitates reusability."
3. "A pattern library makes maintenance easier."



### Pattern Libraries vs. Design Systems vs. Style Guides
It's easy to confuse pattern libraries with design systems and style guides. This [article by Zack Rutherford for UXPin](https://www.uxpin.com/studio/blog/design-systems-vs-pattern-libraries-vs-style-guides-whats-difference/) clarifies the difference between the three:
> • **Design System** – the complete set of design standards, documentation, and principles along with the toolkit (UI patterns and code components) to achieve those standards.
>
> • **Pattern Library** – A subclass in the design system, this is the set of design patterns for use across a company.
>
> • **Style guide** – Another subclass in the design system, this static documentation describes the design system itself: how products should look and feel, use cases for UI patterns, correct typographic scales, etc.


<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->



#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
##### Pattern Library Examples
[Mailchimp](https://ux.mailchimp.com/patterns)

[IBM Design Language](https://www.ibm.com/design/language/resources)

[Microsoft](https://developer.microsoft.com/en-us/windows/desktop/design)

[Google's Material Design](https://material.io/guidelines/)

[UI Patterns](http://ui-patterns.com/patterns)

[Mobile Patterns](http://www.mobile-patterns.com/)

[BBC GEL](http://www.bbc.co.uk/gel/guidelines/category/design-patterns)




##### Articles
["Pattern Libraries" by Natasha Hockey for Prototypr.io](https://blog.prototypr.io/pattern-libraries-5d627c5c65b4)

["Pattern Libraries: What They Are and Why You Need One" by Meghan Lazier for Designlab](http://trydesignlab.com/blog/pattern-libraries-what-they-are-and-why-you-need-o/)

["Creating a Pattern Library" by Rebecca Sorensen for Sumo Logic](https://medium.com/sumo-logic-ux/creating-a-pattern-library-18cce0f901b4)

["Getting Started with Pattern Libraries" by Anna Debenham for A List Apart](http://alistapart.com/blog/post/getting-started-with-pattern-libraries)

["Taking the Pattern Library to the Next Level" by Vitaly Friedman for Smashing Magazine](https://www.smashingmagazine.com/taking-pattern-libraries-next-level/)
