---
title: Personas
---
## Personas

Personas are used in the design process as a guide to create user experiences based on the types of users an application will have. A persona represents a demographic of people who will use the application. Typically, multiple personas are created before the design of an application takes place. The personas will help the designers to create different designs for the different types of users.

For example, if a team was building an application that handled membership and operations for a fitness club, then some of the users of the application might include front desk workers, salesmen, and personal trainers. The ages, mindset, and technical ability of these users might be very different. So the team would create a persona for each of these user types and include details about that user's job, skill level, goals, background, and a short description about that individual's day-to-day activities. 

## User Persona

A user persona is a fictional profile or representation of an ideal user you are trying to reach. Designers use personas to better understand their users and customize a design to fit the target audience.

User personas show how a person might use a website or app. A user's needs, goals, and behaviors help designers figure out how they use a product and what the design can do to get a user to do a specific action. A strong user persona clearly identifies what these needs and essential information which can influence the design.

UX designers find as much research as possible to accurately represent their users. The information is organized into groups which represent the ideal users you want to reach. Designers often focus on most important user groups because it is easier to design for a select few than trying to meet the needs of everyone.

Individual user personas are one page and avoid having extra details which don’t affect the final designer or help with any of the design decisions. You must make sure personas are realistic and specific as possible since it will help you find real life users when you are ready to test your product.

## How Define Your User Persona

Designers have different ways of creating a user persona, but well defined personas have 4 elements. These elements are:

1.Header
2.Demographic Profile
3.End Goal(s)
4.Scenario

### Headers

Headers include the name of your user, mage, and often a quote. The quote is a way designers summarize what the user thinks is important. A strong header keeps designers concentrated on the users they are building for.

### Demographic Profiles
Demographic profiles contain all data from user research. All the data gives designers a complete picture of their users. There are four sections to the profile: personal background, professional background, user environment, and psychographics.

Personal background is information such as age, gender, ethnicity, and education. Designers can include the family status (e.g. single, married, widowed, etc.) or persona group (e.g. working moms).Professional background is the user’s job occupation, income level, and work experience.

User environment is physical, social, and technological context of a user. This information shows what a user’s typical day is, where they spend their time, and what they do with others. Psychographics are research on how your users think and feel. This data focuses on the attitudes, interests, motivation, and pain points of your users.

### End Goal(s)
An end goal is the action users take to complete a goal. End goals motivate all users and show what users want or need.

### Scenario
Scenarios is a description of how users would use a product to accomplish an end goal. These situations define when, where, and how this event would take place. You write these scenarios from the perspective of the user.

#### More Information:

- <a href="https://www.usability.gov/how-to-and-tools/methods/personas.html" target='_blank' rel='nofollow'>Personas - usability.gov</a>
- [Smashing Magazine: A Closer Look At Personas](https://www.smashingmagazine.com/2014/08/a-closer-look-at-personas-part-1/)
- [How to create user personas that deliver real value](https://uxmastery.com/personas-that-deliver-real-value)
