---
title: Prototyping
---
## Prototyping

In software development, a prototype is a rudimentary working model of a product or information system, usually built for
demonstration purposes or as part of the development process. In the systems development life cycle (SDLC) Prototyping Model,
a basic version of the system is built, tested, and then reworked as necessary until an acceptable prototype is finally
achieved from which the complete system or product can now be developed.

Prototyping refers to an initial stage of a software release in which developmental evolution and product fixes may occur
before a bigger release is initiated. These kinds of activities can also sometimes be called a beta phase or beta testing,
where an initial project gets evaluated by a smaller class of users before full development.

Prototyping, as well as broad-spectrum testing and multiple software releases, is part of a more detailed process for
producing sophisticated software products and services. The essential idea is that even when code features are complete on a
project, the software, which is still in development, may have many bugs and user problems. For many of these to get ironed
out, it helps if the software is actually in use, but developers face the issue of releasing a product that end-users can see
as essentially flawed. Releasing the product to a smaller community or otherwise restricting its development in stages can be
a very effective solution.

In some cases, prototyping might involve volunteers, while in other cases, special clients or others with special status may
be involved in prototyping. Development teams and tech companies will typically elicit feedback on a product during
prototyping in order to fix problems before final distribution.

## Tools

Some popular prototyping tools among UX designers include:

- Sketch - https://sketchapp.com
- InVision - https://invisionapp.com
- Axure - https://www.axure.com
- Adobe XD CC - https://www.adobe.com/in/products/xd.html
- Figma - https://figma.com
- UXPin - https://www.uxpin.com/
- Framer - https://framer.com
- Proto.io - https://proto.io/
