---
title: Qualitative Surveys
---
## Qualitative Surveys

Qualitative surveys—which can take the form of interviews or other directly-observed usability tests (can be in-person or via video-conferencing tools like Skype or Google Hangouts)—tend to be exploratory and with the goal of gaining a more in-depth understanding of the user's experience. Qualitative surveys aim to gather information on a user or group's everyday life experiences and motivations to see how these details might affect their use of the product or tool.

### Results

When using qualitative research methods, it is important for the researcher to recognize that they may have an effect on the research results. Since it is the human experience that is being researched instead of hard data (number of clicks, login location trends, etc.), it is difficult to remain completely objective during testing or when assessing results. The results also won't necessarily be reproducible. This is because the factors that affect a user's experience are varied and can change from day to day. These factors can take the form of a user being more stressed one day than another due to new events in their life or having more responsibilities that day, users having completely different life experiences than one another, bad weather affecting the user's mood, and anything else that affects a person's personal or emotional life.

Results of qualitative surveys are typically shown as themes or categories instead of numbers.<sup>1</sup> 

### Example

Here's a great example from [The Interaction Design Foundation](https://www.interaction-design.org/) on the difference between quantitative research and qualitative research:

> To illustrate the difference, let’s say you want to study a user group’s exercise habits. You can choose to study these using either quantitative or qualitative research methods. **If you use a *quantitative* method**, you could create an online survey and distribute it to a large number of participants. Participants must answer predefined questions about their exercise habits such as “How many hours per week do you exercise?”. If you do your job dutifully, the survey answers can be numerically summarized without bias from your own opinion or personal experience with exercise.
> 
> **If you use a *qualitative* method**, you could choose to do interviews with a limited number of participants, where you talk to the participants about when, where, and how they exercise. Because the interview is similar to a conversation, your results will depend on how you ask follow-up questions to the participants’ answers – and how you do that will to some extent depend on your personality and your own experience with exercise. Similarly, the results of the interview also, to some extent, depend on a subjective interpretation of what the participant has told you. 

### Sources

1. [Mortensen, Ditte. "[Best Practices for Qualitative User Research](https://www.interaction-design.org/literature/article/best-practices-for-qualitative-user-research)." *[Interaction Design Foundation](https://www.interaction-design.org/)*. January, 2018. Accessed: February 23, 2018](#)

### Resources:

* "[Qualitative Research Methods in UX Design](https://www.slideshare.net/uxtalktokyo/ux-tokyo-talk-6-markus)" by Markus Heberlein (SlideShare presentation, shown at UX Tokyo Talk 2014)

* "[12 UX Research Techniques (Quantitative abnd Qualitative)](https://medium.com/ux-design-web-mobile-virtual-reality/12-ux-research-techniques-quantitative-and-qualitative-1a37bcb1914e)" by Kevin Dalvi

* "[Complete Beginner's Guide to UX Research](http://www.uxbooth.com/articles/complete-beginners-guide-to-design-research/)" by [UX Booth](http://www.uxbooth.com/)

* "[A Crash Course in UX Design Research](https://uxdesign.cc/a-crash-course-in-ux-design-research-ea00c3307c82)" by Matt Lavoie at [UX Collective](https://uxdesign.cc/)

