---
title: User-Centered Design
---

## User-Centered Design
User centered design (UCD) is a collection of processes which focus on putting users at the center of product design and development. UCD is an
iterative design approach that aims to develop an understanding of user needs, doing so through a mixture of investigative (e.g., surveys and
interviews) and generative (e.g., brainstorming) methods and tools. Crucially, UCD heavily involves users in all design and evaluation phases.
Designers examine the usability, characteristics, environment, and tasks of a product and are extensively attentive to all steps of the design process.

The main goal of UCD is to optimize the product, service, or process around how users will use the product, rather than forcing users to confirm or
change their behavior to adapt the product. 

### Phases of the UCD Process
1. Specify the context of use: Identify the people who will use the product, what they will use it for, and under what conditions they will use it.
2. Specify requirements: Identify any business requirements or user goals that must be met for the product to be successful.
3. Create design solutions: This part of the process may be done in stages, building from a rough concept to a complete design.
4. Evaluate designs: Evaluation, ideally through usability testing with actual users, is as integral as quality testing is to good software development

### User-centered design vs. Human-centered design
User-centered design is often used interchangeably with human-centered design, but the former is actually a subset of the latter. User-centered design concerns itself not just with catering to any particular human user, but a specific type of user. Thus, user-centered design requires deeper analysis of users – your target audience. It is not only about general characteristics of a person; it is about particular habits and preferences of target users to come up with right solutions for specific problems.

User-centered design takes into account age, gender, social status, education and professional background, influential factors, product usage expectations and demands and many other important things that may vary for different segments.User-centered design is about deep research on users’ habits, from their interactions with the product to their vision of how the product should look like and behave.

#### More Information:
* [User-Centered Design: An Introduction](https://usabilitygeek.com/user-centered-design-introduction/) - Usability Geek
* [Benefits of User-Centered Design](https://www.usability.gov/what-and-why/benefits-of-ucd.html)
