---
title: User Research
---
## User Research
User-experience research methods are great at producing data and insights, while ongoing activities help get the right things done. Alongside R&D, ongoing UX activities can make everyone’s efforts more effective and valuable. At every stage in the design process, different UX methods can keep product-development efforts on the right track, in agreement with true user needs and not imaginary ones.

#### 20 UX Methods in Brief
Here’s a short description of the user research methods shown in the above chart:

*Usability-Lab Studies:* participants are brought into a lab, one-on-one with a researcher, and given a set of scenarios that lead to tasks and usage of specific interest within a product or service.

*Ethnographic Field Studies:* researchers meet with and study participants in their natural environment, where they would most likely encounter the product or service in question.

*Participatory Design:* participants are given design elements or creative materials in order to construct their ideal experience in a concrete way that expresses what matters to them most and why.
Focus Groups: groups of 3–12 participants are lead through a discussion about a set of topics, giving verbal and written feedback through discussion and exercises.

*Interviews:* a researcher meets with participants one-on-one to discuss in depth what the participant thinks about the topic in question.

*Eyetracking:* an eyetracking device is configured to precisely measure where participants look as they perform tasks or interact naturally with websites, applications, physical products, or environments.

*Usability Benchmarking:* tightly scripted usability studies are performed with several participants, using precise and predetermined measures of performance.

*Moderated Remote Usability Studies:* usability studies conducted remotely with the use of tools such as screen-sharing software and remote control capabilities.

*Unmoderated Remote Panel Studies:* a panel of trained participants who have video recording and data collection software installed on their own personal devices uses a website or product while thinking aloud, having their experience recorded for immediate playback and analysis by the researcher or company.

*Concept Testing:* a researcher shares an approximation of a product or service that captures the key essence (the value proposition) of a new concept or product in order to determine if it meets the needs of the target audience; it can be done one-on-one or with larger numbers of participants, and either in person or online.

*Diary/Camera Studies:* participants are given a mechanism (diary or camera) to record and describe aspects of their lives that are relevant to a product or service, or simply core to the target audience; diary studies are typically longitudinal and can only be done for data that is easily recorded by participants.

*Customer Feedback:* open-ended and/or close-ended information provided by a self-selected sample of users, often through a feedback link, button, form, or email.

*Desirability Studies:* participants are offered different visual-design alternatives and are expected to associate each alternative with a set of  attributes selected from a closed list; these studies can be both qualitative and quantitative.

*Card Sorting:* a quantitative or qualitative method that asks users to organize items into groups and assign categories to each group. This method helps create or refine the information architecture of a site by exposing users’ mental models.

*Clickstream Analysis:* analyzing the record of screens or pages that users clicks on and sees, as they use a site or software product; it requires the site to be instrumented properly or the application to have telemetry data collection enabled.

*A/B Testing (also known as “multivariate testing,” “live testing,” or “bucket testing”):* a method of scientifically testing different designs on a site by randomly assigning groups of users to interact with each of the different designs and measuring the effect of these assignments on user behavior.

*Unmoderated UX Studies:* a quantitative or qualitative and automated method that uses a specialized research tool to captures participant behaviors (through software installed on participant computers/browsers) and attitudes (through embedded survey questions), usually by giving participants goals or scenarios to accomplish with a site or prototype.

*True-Intent Studies:* a method that asks random site visitors what their goal or intention is upon entering the site, measures their subsequent behavior, and asks whether they were successful in achieving their goal upon exiting the site.

*Intercept Surveys:* a survey that is triggered during the use of a site or application.

*Email Surveys:* a survey in which participants are recruited from an email message.

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:
<a href='https://www.nngroup.com/articles/ux-research-cheat-sheet/' target='_blank' rel='nofollow'>UX Research Cheat Sheet</a>


