---
title: Customer Interviews
---
## Customer Interviews

Building personas sometimes involve research. This research can be in the form of customer interviews. This is a one-on-one interaction with existing or potential users. It is used to gain qualitative information about users of your product. 

It is usually conducted by two persons: one does the questioning while the other person takes notes. Questions are usually centered around:

* Background.
* Demographics.
* Identifiers.
* Goals.
* Challenges. 
* Possible solutions.

Before committing to building a product, it is important to know who you are building it for. Once you have defined what the audience (who you anticipate your customers are) for your product, you should find a group of people that meet that criteria, and ask them questions. For example, if you are planning to build a platform for new moms to schedule playdates for their children, you should ask some moms about what they need from your software.

When you are doing your customer interviews, it is important to focus on the problem that you are solving, rather than on the tech that you are building. You want to have an open conversation with your potential customer, but have some guidelines for what information you want from them. Ask your potential customer if there is anything that you did not ask them, or if they can think of someone else who you should talk to.

When you reach out to someone to participate in a customer interview, remember that you're not selling them anything yet. Be respectful of their time; you may only get 10-20 minutes. If you can compensate them for their time, that is a good idea.

Be careful when devising your questions that they do not force the response that you are looking for to validate your assumptions. Sometimes the wording of a question can make a respondant give an answer that they would not ordinarily think to give. When asking about the potential customer's behavior, ask about the present, rather than what they plan to do in the future. This will give a more accurate and less idealistic view of how your customer's will interact with your product. 

Avoid talking about your product. You don't want to be pitching it: it hasn't been built yet. You want to be learning more about the problems your users face so that you can build the best solution. This also eliminates the need for Non-Disclosure Agreements. Don't ask your potential customer to sign one.

Encourage your interviewee to tell you stories. You're looking for qualitative data at this point. Having these stories will also be beneficial when you go to pitch your product, because it shows that you have a greater understanding of the problem that you are solving. Take lots of notes so that you remember these stories!

#### More Information:
<!-- Please add any articles you think might be helpful to read before writing the article -->
 - <a href="https://venturewell.org/customer-interviews/">Do's and Don'ts of Customer Interviews</a>
 - <a href="https://www.slideshare.net/ZacharyCohn/18-customer-interview-tips">Zachary Cohn's Customer Interview Tips Presentation</a>
 - "User Interviews – The Beginner’s Guide." theUXreview, 25 Oct. 2017, http://theuxreview.co.uk/user-interviews-the-beginners-guide/.

