---
title: Storyboards
---
## Storyboards

Storyboards are used to paint a visual picture of a user's journey with a product or software. 

Storyboarding involves using visual images to create a story. This creates a more lasting impression than plain text. 

As a best practice, it's the first sketch of the expected functionality of a project (e.g. a website, application, service, etc.). It has the purpose to aid in the planning of the requirements of the project and to outline the necessary steps (workflow) that completing a task requires. For instance, a sketch of an authentication web page lays out (before any code), what type of data is required from the user, what actions are necessary to perform in the back end, and what is the expected output of the action.

Storyboarding is a great technique when attempting to develop or or explain an experience. Storyboarding does not require fine art skills, but rather emphasises the visual and creation of narrative in an explanation. Much like a comic book, storyboarding takes individual images (much like a snapshot) of a story. These images are then placed in a certain order producing a sequential artwork where the viewer's brain forms the connections between the images to produce the narrative. When making a storyboard, the "snapshots" you select to tell the story can be critically reflected on to better review the author's position and perspective on the story. Storyboards can be used for a multitude of areas, including coding since it can develop a comprehensive and unified understanding of functions and intended user experience when using software. One of the main benefits of storyboarding is that the use of stories are more engaging than listing facts and can increase viewer memory, for this reason storyboards can be great tools when making presentations. 

#### More Information:

* To learn more about storyboarding, you visit this [link](https://uxplanet.org/storyboarding-in-ux-design-b9d2e18e5fab?gi=84d3b1dc4704) 
* [Wikipedia](https://en.wikipedia.org/wiki/Storyboard)
