---
title: Vim
---
# Vim

<a href='https://vim.sourceforge.io' target='_blank' rel='nofollow'>![logo](https://upload.wikimedia.org/wikipedia/commons/thumb/9/9f/Vimlogo.svg/75px-Vimlogo.svg.png "Vim logo")</a>

Vim (Vi IMproved) is a highly configurable text editor built to make creating and changing any kind of text very efficient. It is included as "vi" with most UNIX systems, which also includes Apple's macOS. Vim is a major improvement over its predecessor *vi*, which was developed over 40 years ago, and it is still being used.

Vim is rock stable and boasts many features including:
- persistent, multi-level undo tree
- extensive plugin system
- support for hundreds of programming languages and file formats
- powerful search and replace
- integrates with many tools
- built-in macro support for automation text manipulation
- usable on systems that lack support for GUI based text editors

One of the main differences that both Vim, and its predecessor *vi*, have over other editors like *nano*, is that it is a _modal editor_, which means that they have several modes of operation. For example, the editor starts in *Navigation Mode*, which allows you to quickly move around the document (or, more accurately _blazingly fast_). In this mode, you can enter commands to interact with your document, like using `:i` to enter `insert mode`, `:q` to quit, `/<text>` to search text, among others. 

The modal part of Vim is what makes it really powerful. You can try out the most powerful features through an interactive tutorial by visiting [OpenVim](http://www.openvim.com/) 

If you have vim installed on your system, you can also run the `vimtutor` command to start a tutorial.

## More information

* [Vim's homepage](https://vim.sourceforge.io)
* [Vim.org](https://www.vim.org/) is an online resource with downloadable binaries for most operating systems. 
* [Open Vim](http://www.openvim.com/) is an online, interactive Vim tutorial you can do right in your browser. 
* [Vim Adventures](https://vim-adventures.com) is an online game based on VIM's keyboard shortcuts. It's the "Zelda meets text editing" game.
* [Vim Awesome](https://vimawesome.com/) provides descriptions and links to VIM plugins.
* [Super necessary Vim shortcuts](https://www.maketecheasier.com/vim-keyboard-shortcuts-cheatsheet/)
