---
title: Vim-Plug
---
## Vim-Plug

Vim-Plug minimalist Vim plugin manager.

### Pros :
- Easier to setup: Single file. No boilerplate code required.
- Easier to use: Concise, intuitive syntax.
- Super-fast parallel installation/update (with any of `+job`, `+python`, `+python3`, `+ruby`, or Neovim).
- Creates shallow clones to minimize disk space usage and download time.
- On-demand loading for faster startup time.
- Can review and rollback updates.
- Branch/tag/commit support.
- Post-update hooks.
- Support for externally managed plugins.

You can find the installation guide <a href='https://github.com/junegunn/vim-plug#installation' target='_blank' rel='nofollow'>here </a>.

Some useful plugins to get you started are :
- <a href='https://github.com/scrooloose/nerdtree' target='_blank' rel='nofollow'>nerdtree</a> - A file system explorer for the Vim.
- <a href='https://github.com/mattn/emmet-vim/' target='_blank' rel='nofollow'>Emmet-vim</a> - Support for expanding abbreviations similar to <a href='https://emmet.io/' target='_blank' rel='nofollow'>emmet</a>.
- <a href='https://github.com/sheerun/vim-polyglot' target='_blank' rel='nofollow'>vim-polygot</a> - A solid language pack for Vim. 
- <a href='https://github.com/jiangmiao/auto-pairs' target='_blank' rel='nofollow'>Auto Pairs</a> - Insert or delete brackets, parens, quotes in pair.
- <a href='https://github.com/tpope/vim-fugitive' target='_blank' rel='nofollow'>fugitive.vim</a> - A git wrapper for Vim.
- <a href='https://github.com/Townk/vim-autoclose' target='_blank' rel='nofollow'>vim-autoclose</a> - vim automatically completes parentheses

You may add more plugins to your Vim installation.

#### More Information:
- <a href='https://github.com/junegunn/vim-plug' target='_blank' rel='nofollow'>GitHub Repository</a> - Vim-Plug
- <a href='https://vimawesome.com/' target='_blank' rel='nofollow'>VimAwesome</a> - Explore Vim plugins</a> 
