---
title: Vundle
---
## Vundle

Vundle is short for Vim bundle and is a Vim plugin manager.

It allows you to...
- keep track of and configure your plugins right in the `~/.vimrc` (a [file](https://stackoverflow.com/questions/164847/what-is-in-your-vimrc) to customise Vim)
- install configured plugins (a.k.a. scripts/bundle)
- update configured plugins
- search by name all available Vim scripts
- clean unused plugins up
- run the above actions in a single keypress with interactive mode

To get started, follow <a href='https://github.com/VundleVim/Vundle.Vim#quick-start' target='_blank' rel='nofollow'>this guide</a>.

Some useful plugins to get you started are :
- [nerdtree](https://github.com/scrooloose/nerdtree) - File tree explorer
- [syntastic](https://github.com/vim-syntastic/syntastic) or [ale](https://github.com/w0rp/ale) - Syntax checker / linter 
- [tagbar](https://github.com/majutsushi/tagbar) - Displays tags in a window
- [ctrlp](https://github.com/kien/ctrlp.vim) - Fuzzy file, buffer, mru, tag, etc finder
- [gitgutter](https://github.com/airblade/vim-gitgutter) - Shows a git diff in the gutter (sign column)
- [fugitive](https://github.com/tpope/vim-fugitive) - Git wrapper
- [delimitMate](https://github.com/Raimondi/delimitMate) - Insert mode auto-completion for quotes, parens, brackets, etc
- [tcomment](https://github.com/tomtom/tcomment_vim) - Comment lines whatever the language
- [and tons more!](https://vimawesome.com/)


#### More Information:
- <a href='https://github.com/VundleVim/Vundle.Vim' target='_blank' rel='nofollow'>GitHub Repository</a>

