---
title: Color Theory
---
## Color Theory

Color Theory is a practical application of mixing colors and using color to achieve a specific visual effect.

Colors are used in all sorts of ways.

The choice of colors in visual display is often constrained by hardware, software running on the hardware, limitations of the human eye and variations on how humans perceive color.

Limits to choices are also shaped by artificial constraints supplied by a project, such as having to conform to design style and branding.

A color wheel is the main tool used by designers to specify or locate color. Color wheels can include the entire color spectrum or they can be organized by a defined category of colors. 

The four main categories of colors, which you might already be familiar with, are Primary Colors, Secondary Colors, Tertiary Colors, and Complementary Colors.

Using color theory can help meet the requirements of projects while maximizing legibility of text and accessibility of content to viewers with different viewing traits or needs.

### Color Wheel or Color Picker

A color wheel or picker is a tool used by designers to specify or locate color.
Color pickers may include a color spectrum or they may be organized by defined categories of light, such as brightness and hue.


**Primary Colors**

In art and illustration, colors are traditionally separated into three categories: Primary Colors, Secondary Colors, and Tertiary Colors.
Primary colors are colors that cannot be mixed or formed by any combination of other colors.
Secondary colors are the ones formed by mixing two primary colors.
Tertiary colors are the ones formed by mixing all three primary colors.

In traditional painting, the colors are red, yellow and blue (RYB).
All other colors are derived from these three.
The actual hue of each primary color affects the range of colors available.

Computer visual displays commonly use a different set of three primary colors to approximate color: red, green and blue (RGB).
Every color displayed is made of varying the brightness of the primary colors.

Computer printers commonly use four primary colors to represent color.
Black is sometimes used as a contrast medium to increase the range of contrast.
The combination of Primary colors Cyan, Magenta, Yellow, and Key (CMYK) is common. "Key" represents black.
Key is a traditional term for the most significant impression of a combination of imprints.

### Color Psychology

Color Psychology is a study of how color influences human mood and behavior. The colors chosen for the design can influence how 
successful a product is.

**Complementary Colors:**
Red-green, yellow-purple, blue-orange
These are colors formed by mixing colors that are opposite from each other on the color wheel.
When chosing to work with complementary colors, the ratio between them is very important. While a 50 50 ratio could work for the red and green pair, it would produce unpleasing results in a yellow purple pair. 

The basic complementary ratios are:
```
Red-Green : 50% 50%
Orange-Blue : 30% 70%
Yellow-Purple : 10% 90%
```

In web design, colors also carry with them connotations and implications that need to be understood or else you could cause confusion. The color red in a non-digital space, such as a fast-food restaurant, carries the implication of energy or excitement. However, on the web the color red also carries with it the implication that the user has committed an error. This example of how color means certain things in certain settings should be a critical reminder to understand how the person viewing your page will interpret the color selection you’ve made.

### Web colors

Web standards including HTML, CSS, and graphics file formats: jpeg, PNG, GIF, and SVG use primary colors of red, green, and blue.
Each technology or device displays a slightly different hue of primary color.
For example, a pure red on one monitor may look more pink or orange on another.
These variances add to the complexity of attempting to portray accurate colors on a computer screen.
This is a significant issue, for example, when trying to:

* represent a product with a specific color hue, or
* represent a rainbow of color, or
* alert a user with messages having various degrees of importance.

Web design, advertising, and human-computer interface heuristics also recognize that colors carry cultural connotations and implications. 

<a href='https://github.com/freecodecamp/guides/blob/master/README.md' target='_blank' rel='nofollow'>This quick style guide will help ensure your pull request gets accepted</a>.

<!-- The article goes here, in GitHub-flavored Markdown. Feel free to add YouTube videos, images, and CodePen/JSBin embeds  -->

#### More Information:

<a href="http://lfhs.lfcisd.net/UserFiles/Servers/Server_904/File/ECCastillo/Color%20Theory%20Worksheet.pdf">Basic Color Theory Worksheet</a>

<a href="https://en.wikipedia.org/wiki/Color_psychology">Color Psychology Wiki</a>

[Table of spectral or near-spectral colors in RGB](https://en.wikipedia.org/wiki/Spectral_color#Table_of_spectral_or_near-spectral_colors)

[Color and Usability](/visual-design/color-theory/usability/index.md)

[Color and Culture](/visual-design/color-theory/color-and-culture/index.md)

[How to get a professional look with color](https://www.webdesignerdepot.com/2009/12/how-to-get-a-professional-look-with-color/)

[Its Only Color](https://robots.thoughtbot.com/Its-only-color)


