---
title: Visual Design
---
## Visual Design

In this section, we'll have guides to a wide variety of visual design concepts.


Various design methodologies can be employed when doing visual design - for example, 'brutal' or 'post-punk'. Different companies have their own design languages in a broad sense. For example, Google is a large propogator of [Material Design](https://material.io) in which design elements are made to look like real materials with the same flow and shadow effects.

Visual Design deals with how an application looks to the user as well as how it feels. It can be seen as the digital equivalent of graphic design. And as such, visual design should also strive to follow Dieter Rams' well-known principles of good design.


### 10 Principles of Good Design
1. Good design is innovative
2. Good design makes a product useful
3. Good design is aesthetic
4. Good design makes a product understandable
5. Good design is unobtrusive
6. Good design is honest
7. Good design is long-lasting
8. Good design is thorough down to the last detail
9. Good design is environmentally friendly
10. Good design involves as little design as possible


### More Information
- [10 timeless commandments for good design](https://www.interaction-design.org/literature/article/dieter-rams-10-timeless-commandments-for-good-design)
