---
title: Layout
---
## Layout

Layout refers to the arrangement or placement of elements on a given page. Elements can include functional items such as paragraphs, headings, lists, and sections. Elements can also include design items such as icons, shapes, and images. The use of whitespace, padding, and margin is also used heavily in layout. You can consider the former to be design characteristics rather than elements in and of themselves.

The layout of a page is the arrangement of these various items into a presentation that conveys meaning to the person viewing the page. Thus, a primary consideration for layout should be how the layout will be understood and what meaning it will ultimately convey. Without carefully considering the meaning of a layout, you can cause confusion and distrust amongst your target audience.

One common mistake you might make is to determine layout based on what you think looks best. Doing this can violate the idea of standard conventions and should be avoided until you are more experienced in layout design.

Standard Conventions is a term used to describe a process or application of a technique that has industry-wide approval and general cultural acceptance amongst users.
Examples of these conventions as it relates to layout are listed below:
*	Placement of heading text above the paragraph it’s meaning to describe
*	Placement of a navigation bar at the top of the page
*	Use of whitespace to separate different sections and types of content
*	Lack of whitespace to bring together sections and types of content
* Ensuring elements are neat and organized (i.e two buttons aligning to be visually acceptable)
* Simplicity of the layout such that it is easy to follow and flows nicely
* Use of visual hierarchy to help keep the layout visually flowing (Size, color, positioning, etc)

## Works everytime layout (A.K.A. W.E.T Layout)

The works everytime layout is based on the west's way of reading: Left to Right, Top to Bottom. Normally, you would only use this for a one page layout, so the margins that you would want to set on your document would be .5 inches all around the document, using whatever page layout software you like. The top of the page usually uses an eye-catching image, and below the image should be your headline. These will determine if your audience will read the rest of your article or whatever else you've designed. 

- "Keep your headline and lead together. The lead is the first paragraph of your text. Also, don’t indent the lead under the headline."
- "Keep your copy (the text) in columns to help manage readability and clutter. You want your columns to be between 2 and 10 inches long. No more, no less. When it comes to width, keep your columns between 6 to 12 words.
- "Along those lines, keep your paragraphs short and to the point, and use fonts that are easy to read. That means no script!"

Once the body copy has been taken care of, you can then add the tags. Tags are an advertising term that refers to the information usually found at the bottom right hand part of the page.

[TheKatHunts. “Good Design: Works-Every-Time Layout”](https://writingwithmagneto.wordpress.com/2014/03/14/good-design-works-every-time-layout/)

[A video on the works everytime layout](https://whitespacedesignbook.com/portfolio/works-every-time-layout/)

## Resources
* Layout Essentials: 100 Design Principles for Using Grids
[Amazon](https://www.amazon.com/Layout-Essentials-Design-Principles-Using/dp/1592537073)
* Layout Workbook: A Real World Guide to Building Pages in Graphic Design
[Amazon](https://www.amazon.com/Layout-Workbook-Real-World-Building-Graphic/dp/1592533523)
