---
title: Vue
---
# Introduction

Vue.js is a progressive client-side JavaScript web framework for creating single-page web applications according to the MVVM pattern, but it can also be used in multi-page web pages for individual sections. Starting with version 2.0, it also supports server-side rendering.

Vue.js was first released in 2014 by Evan You. It was created as a better version of Angular - lighter, removing all extra concepts, and easier to learn.

## Concept

The developers describe Vue.js as progressive and incrementally adaptable compared to other web frameworks. This allows the developer to customize the structure of the application. The developers describe Vue.js as easier to learn than AngularJS, because the API was kept simple. To learn Vue.js knowledge in Javascript and HTML is sufficient.

By implementing the MVVM pattern, Vue.js offers the possibility of data binding, so that outputs and inputs are directly linked to the data source. This means that manual determination of the data (e.g. via jQuery) from the HTML DOM is not necessary.

Its core is focused on only the "view" layer and can be easily integrated with existing libraries and projects.

But on the other hand, Vue.js can also be leveraged to create powerful single page applications by integrating with extensions
such as `vue-router` for page routing and `vuex` for state management.

Its main attributes are the following:
* It's approachable: If you know basic HTML, CSS & JavaScript - then you'll be writing apps in Vue.js in no time!
* It's versatile: You can use it as a simple library or a fully featured framework.
* It's performant: It's extremely performant out of the box with very little to almost no optimization required.

#### More Information

- [Vue.js Homepage](https://vuejs.org/)
- [GitHub Repo](https://github.com/vuejs/vue/)
- [News — Vue.js](https://news.vuejs.org/)
- [Vue.js Showcase - Made With Vue.js](https://madewithvuejs.com/)
- [Vue-cli](https://cli.vuejs.org/) - standard tooling
- [Vue-Router](https://router.vuejs.org/) - officially-supported vue-router library
- [Vuex](https://vuex.vuejs.org/) - state management pattern + library
- [Vuetify](https://vuetifyjs.com/en/) a Material Design Framework for Vue
- [Comparison with other frameworks](https://vuejs.org/v2/guide/comparison.html)

