---
title: Web Components
---

## What are web components?

Web components are comprised of a series of web specifications created by the [W3C](https://w3c.github.io/).
These specifications describe a set of web platform APIs that can be used to create reusable, encapsulated, and customizable HTML elements.
By exposing the low level web APIs used by browser vendors to create the HTML elements you may already be familiar with, web components can be used across
a variety of environments.
This means whether you're working on a Wordpress site, a server rendered application, a Single Page Application (SPA) with the latest framework, or no framework at all,
web components can be used.
For the first time, regardless of what framework is used, you can understand the web as a platform to creature unique experiences that are easily
translated from one platform to another.

## Web Component Specifications

Web components are defined in [four main specifications](https://www.webcomponents.org/introduction#specifications).

- **Custom Elements**

  - The [Custom Elements specification](https://w3c.github.io/webcomponents/spec/custom/) lays the foundation for designing and using new types of DOM elements.

- **Shadow DOM**

  - The [Shadow DOM specification](https://w3c.github.io/webcomponents/spec/shadow/) defines how to use encapsulated style and markup in web components.

- **ES Modules**

  - The [ES Modules specification](https://html.spec.whatwg.org/multipage/webappapis.html#integration-with-the-javascript-module-system) defines the inclusion
    and reuse of JS documents in a standards based, modular, performant way.

- **HTML Template**
  - The [HTML template element specification](https://html.spec.whatwg.org/multipage/scripting.html#the-template-element/) defines how to declare
    fragments of markup that go unused at page load, but can be instantiated later on at runtime.

### More Information:

- [Introduction to web components](https://www.webcomponents.org/introduction)
- [Extensible Web Manifesto](https://github.com/extensibleweb/manifesto)
- [W3C Web Component Specification](https://w3c.github.io/webcomponents/explainer/)
