---
title: Virtual Reality Development on The Web
---
## Virtual Reality Development on The Web

This section contains articles related to Virtual Reality Application Development using frameworks such as the A-Frame Framework, WebVR, Three.js and React 360 formerly known as React-VR.

## Frameworks

* A-Frame - https://aframe.io/
* Three.js - https://threejs.org/
* React 360 - https://facebook.github.io/react-360/

## Historical Resources on Virtual Reality

* Virtual Reality Society, UK - https://www.vrs.org.uk/virtual-reality/history.html


## Virtual Reality Headsets and More

* Comparison of virtual reality headsets on Wikipedia - https://en.wikipedia.org/wiki/Comparison_of_virtual_reality_headsets
* Google Cardboard - https://vr.google.com/cardboard/
* Google Daydream - https://vr.google.com/daydream/
* Oculus - https://www.oculus.com/
* Pimax - https://pimaxvr.com/
* Samsung Gear VR - https://www.samsung.com/global/galaxy/gear-vr/
  * https://samsungvr.com/
* HTC - https://www.vive.com/us/

## 3D Content Resources

* Sketchfab - https://sketchfab.com/
* Poly - https://poly.google.com/

## Examples of Various Virtual Reality Creations

* The starry night Stereo VR experience - https://youtu.be/G7Dt9ziemYA
* Being inside a Van Gogh painting - https://gfycat.com/SimpleImaginaryIberianmidwifetoad 
* Multi-Surface and 3D - https://facebook.github.io/react-360/docs/example-multisurface.html

## A few companies making tools for VR on the Web

* Scapic - https://scapic.com
* Vizor - https://site.vizor.io/
* Mirra - https://mirra.co/

## Browser Compatibility

* WebVR support was added in Firefox version 55. - https://support.mozilla.org/en-US/kb/view-virtual-reality-firefox-webvr
* WebVR support was added to Chrome version 65 Canary Builds - https://webvr.info/get-chrome/
