---
title: WordPress
---

![wordpress logo][logo]

[logo]: https://s.w.org/style/images/about/WordPress-logotype-standard.png

## WordPress

WordPress is a free and open-source [content management](https://en.wikipedia.org/wiki/Content_management_system) system based on **PHP** and **MySQL**. It is maintained by [Automattic](https://automattic.com) and an international community of developers. Its features include robust user management, an extensible theming and plugin architecture, and a flexible template system. It is most often associated with blogging but supports other types of web content including forums, media galleries, and online stores.

WordPress was first launched in 2003 and now powers over 30% of all websites. It is by far the most used CMS on the planet. Backed by a huge community, this open source platform powers not only countless sites but a multi-billion dollar economy with themes, plugins, and custom software.

Both easy to use and highly customizable, Wordpress offers an easy solution for both web developers and non-web developers alike to create a site.

Just to name a few advantages of WordPress:
* Users are able to manage their Wordpress webpage from any computer
* Has a blog built-in and ready to go whenever applicable. 
* Has continous updates that occur every 3-4 months. 
* SEO compatible so that the sites can be found easier. 
* Has plugins, which extend functionality to WordPress sites.
* Has mobile app (Android and iOS), which can be used to post and manage their Wordpress webpage.
* Wordpress sites can be hosted on any server running the LAMP stack
* WordPress themes make it possible for non-designers to create a customized website
* Wordpress sites are very scalable, you can start as simple blog then end up with complex online stores, membership, and affiliate program

As a CMS, WordPress allows you to control and manage the content of your website with a very easy system, such as the WordPress dashboard panel. A dashboard lets you do work on your website without needing to program anything. You can add or delete images and edit text on your webpage fast and easily.

Whether it is page transitions or a customized contact form, WordPress users are only a few clicks away from success and a beautiful website.

### WordPress Community

If you would like to meet new people who are interested in Wordpress there are many meetups around the world including huge events called WordCamp which can be a great place to network. 

### WordPress as a Blogging Platform

Blogging is a foundational feature of WordPress. One of the primary things it allows you to do is create individual "posts", and designate a main blog page that displays them in chronological order.

It supports many useful publishing features out of the box, like the ability to add images, save drafts, enable comments, and organize your posts with tags and categories. And it includes an admin dashboard for managing posts, media, site menus, settings, and more.


### WordPress as CMS

In addition to posts, WordPress also comes with the ability to create "pages" — any non-chronological page on your site, like an "About" or "Contact" page. 

What makes WordPress particularly powerful is that it's possible to create other custom page types as well. You could, for example, create your own classifieds site with a "listings" page type, or a book review site with a "review" page type, and even assign custom data fields and taxonomies to these as well. Using a combination of plugins and custom coding, you can adopt WordPress as a content management system for all kinds of uses.

### Templates

WordPress does not require work from scratch. For ease of new developers, there are tons of free templates available on the internet which can be used by a beginner developer. 
Few websites which are providing these free templates are:

- [AThemes](https://athemes.com/collections/free-wordpress-themes/)
- [WordPress](https://wordpress.org/themes/)
- [Just Free Themes](https://justfreethemes.com)

### Themes and Plugins

WordPress has a few great ways to extend its core functionality. Among these, the main buckets are themes and plugins. 

Themes typically provide an overall framework for the design and functionality of a site. WordPress has many free themes available, and there's a large ecosystem of professional-grade themes available at reasonable prices. 

Plugins extend WordPress functionality in specific ways, adding features like mailing list integrations, contact forms, enhanced security, or custom data fields. As with themes, there's a huge number of plugins available, many of them free, or with both free and pro versions available, covering almost any feature you might think of.

While free themes offer a range of beautiful designs, WordPress premium themes for web projects beyond the basics may cost between $10 to $200 with an average of around $59. Also, most plugins are available in free or premium versions.

The following are some of the popular and useful plugins in WordPress:
- Yoast SEO: Improve WordPress SEO
- JetPack
- W3 Total Cache
- Akismet Anti-spam: Filter spam comment 
- Mailchimp
- WooCommerce: Create eCommerce using WordPress
- Elementor: Open source page builder
- WP Super Cache: Increase load speed for a static website

Examples of Popular Drag and drop themes that make a WordPress website easy to build are:
- Avada theme
- [Divi by Elegant Themes](https://www.elegantthemes.com/)
- [Genesis Framework](https://my.studiopress.com/themes/genesis/)
- [Elementor](https://elementor.com/)

#### Wordpress Most used Plugins
- [Most Popular Wordpress Plugins ](https://www.hostgator.com/blog/most-popular-wordpress-plugins/)

### Visual Editors

"What You See Is What You Get" (WYSIWYG) editors for WordPress have increased in popularity over recent years. These visual builders provide user-friendly interfaces that allow users to customize all aspects of their site without a bit of code. Some of the most popular include [Divi](https://www.elegantthemes.com/gallery/divi/) and [Thrive](https://thrivethemes.com/architect/?idev_id=4971), which are both under $90, and [SiteOrigin](https://siteorigin.com/page-builder/), which is a free option. WordPress will be shipping its own visual editor, Gutenberg, as of version 5.0. You can learn more about it here: [Gutenberg](https://wordpress.org/gutenberg/).

#### Gutenberg WordPress editor
In early 2017 WordPress announced that they had been working on the new Gutenberg WordPress editor. The Gutenberg editor is a page builder being developed to integrate with WordPress core. It aims to add flexibility to the content editing experience through the use of content blocks, which can be styled and moved individually. Although it has not yet been officially released, the editor is available for early testing and feedback. WordPress hope to merge the Gutenberg editor into WordPress 5.0.
- [Project Gutenberg](https://wordpress.org/plugins/gutenberg/)


### From Blogging Platform to CMS

The power of WordPress becomes apparent in the use of 3 features: custom post types, custom taxonomies, and custom fields. Generating custom post types allows a website administrator or web developer to separate very specific content types from the rest of their website content. This can be helpful on websites with large page counts and numerous varying content sections.

For example: lets say you have a company website with a large number of products, numerous physical storefront locations, and a news/blog section. If all of that content was all crammed into the default posts or pages section of the website admin panel, navigating said sections could very quickly become an overwhelming mess.

In this instance, you could create a custom post type for products, a custom post type for locations, keep thing the default posts section exclusively for your news/blog content. 

### WordPress.org vs. WordPress.com

The free and open-source version of wordpress is found at [https://wordpress.org](https://wordpress.org) and must be self-hosted on a server or local development machine. This is also the version of WordPress that is frequently available as a simple installation through cPanel on the majority of hosting providers. Meanwhile, a hosted version of WordPress is available [wordpress.com](https://wordpress.com), but this is not an open-source version. Users of the WordPress.com site may need to pay subscription fees to access many of the features and benefits of the open-source WordPress.

Here are some examples of big name brands using WordPress: 
* [Sony Music](https://www.sonymusic.com/)
* [TechCrunch](https://techcrunch.com/)
* [BBC America](http://www.bbcamerica.com/)
* [Bloomberg Professional](https://www.bloomberg.com/professional/)
* [The Walt Disney Company](https://www.thewaltdisneycompany.com/)

Note: WordPress's ease of use may encourage new users to forget about website security. However, the popularity of WordPress increases the activity of malware and other issues. 
It is important to choose extremely difficult or random passwords for the administrators and for the database. This guards against random brute-force attacks. 
Using tools such as [Jetpack](https://jetpack.com/) and an [SSL certificate](https://www.verisign.com/en_US/website-presence/website-optimization/ssl-certificates/index.xhtml) increases your protection against unwanted attacks.

## Get Started With Wordpress
This guide will cover how to set up a basic Wordpress website. If anything is
missing I will go back and add more content.

### Domain
So, you need a domain because you want people to be able to browse your website! Get it from one of the providers, just make sure they 
are reputable enough.

### Hosting
You will also need a place to make sure your website is alive and comfy.
I suggest you not to pick the same company as your domain and hosting
provider.

### Wordpress
You will need Wordpress software to "power" your website. You can get it from: https://http://wordpress.org/download/

### DNS
So, now it is time to link your domain and server. You should be able to browse
the FAQ of the domain provider or ask them to do it for you.
Your hosting provider will give you a nameserver and you can use that DNS
server address for your domain. Go to DNS Zone editor and make sure you
follow the exact steps your domain provider requires.

## Installing Wordpress
If you have cPanel, go on to Softaculous and select Wordpress. It will automatically install Wordpress for your domain name.

### Software Setup
Choose Protocol: http:// (I would prefer this or https://)
Choose Domain: yourdomain.com
In Directory: -Leave Here Empty-

### Site Settings
Site Name: My Blog
Site Description: Awesome blog about cycling and sight-seeing!
Enable Multisite (WPMU): -NO-

### Admin Account
Admin Username: -Enter your desired admin username here-
Admin Password: -Make sure the admin password is difficult- (https://strongpasswordgenerator.com/)

### Choose Language
Select Language: -Pick Your Desired Language-

### Select Plugins
Limit Login Attempts (Loginizer): -NO-

### Advanced Options
-Default are OK-
-Click Install-
Email Installation Details To: -your email-

After confirming installation you will be on the WordPress Dashboard.

## Installation (Development Environment)

### Arch Linux
1. Download WordPress from https://wordpress.org/download/
2. Extract the WordPress files from the .tar.gz archive.
3. Move the extracted WordPress directory to /srv/http. This can be achieved using the following command. Remember to replace the text within the <> with the name of the extracted WordPress directory in your computer (use sudo if superuser access is required):
    ```sh
    mv ~Downloads/<insert WordPress directory here) /srv/http
    ```
4. For **development purposes**, change the user permissions for the WordPress folder to 777. This can be done using the following command:
    ```sh
    sudo chmod -R 777 /srv/http/<insert WordPress directory here)
    ```
5. Open a browser.
6. Navigate to localhost/<insert WordPress directory here).
7. Follow the graphical installer and you're all set.

### Learning Resources
- [Official WordPress Lessons](https://learn.wordpress.com/)
- [WordPress TV](https://wordpress.tv/)
- [WPBeginner-Youtube channel](https://www.youtube.com/user/wpbeginner)

### More Information
- [WordPress Theme Directory](https://wordpress.org/themes/)
- [WordPress Plugin Directory](https://wordpress.org/plugins/)
- [WordPress GitHub Repository](https://github.com/WordPress/WordPress)
- [WordPress Support Forums](https://wordpress.org/support/)
- [Download WordPress](https://wordpress.org/download/)
- [WPHub-WordPress Themes](https://www.wphub.com/)
- [WordPress Code Reference](https://developer.wordpress.org/reference/)
- [Automattic - The Home of WordPress](https://automattic.com/)
- [Advantages of WordPress](https://www.fastwebhost.com/blog/top-advantages-of-wordpress-in-2018/)
- [WordPress Coding Standards](https://make.wordpress.org/core/handbook/best-practices/coding-standards/)
- [WordPress WordCamp Central](https://central.wordcamp.org/)
- [WordPress Codex: the online manual](https://codex.wordpress.org/)
